/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.entity;

import com.github.platymemo.alaskanativecraft.config.AlaskaConfig;
import com.github.platymemo.alaskanativecraft.entity.DogsledEntity;
import com.github.platymemo.alaskanativecraft.entity.HarpoonEntity;
import com.github.platymemo.alaskanativecraft.entity.MooseEntity;
import com.github.platymemo.alaskanativecraft.entity.PtarmiganEntity;
import com.github.platymemo.alaskanativecraft.entity.SealEntity;
import com.github.platymemo.alaskanativecraft.item.AlaskaItems;
import com.github.platymemo.alaskanativecraft.item.HarpoonItem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.mixin.object.builder.SpawnRestrictionAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1429;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_5132;

public class AlaskaEntities {
    private static final Map<class_2960, class_1299<?>> ENTITY_TYPES = new LinkedHashMap();
    public static final class_1299<SealEntity> HARP_SEAL = AlaskaEntities.add("harp_seal", AlaskaEntities.createEntity(class_1311.field_6300, SealEntity::new, true, 1.0f, 0.6f));
    public static final class_1299<PtarmiganEntity> PTARMIGAN = AlaskaEntities.add("ptarmigan", AlaskaEntities.createEntity(class_1311.field_6303, PtarmiganEntity::new, false, 0.5f, 0.5f));
    public static final class_1299<MooseEntity> MOOSE = AlaskaEntities.add("moose", AlaskaEntities.createEntity(class_1311.field_6294, MooseEntity::new, true, 3.0f, 2.6f));
    public static final class_1299<DogsledEntity> DOGSLED = AlaskaEntities.add("dogsled", AlaskaEntities.createEntity(class_1311.field_17715, DogsledEntity::new, false, 1.5f, 1.0f));
    public static final class_1299<HarpoonEntity> WOODEN_HARPOON = AlaskaEntities.add("wooden_harpoon", AlaskaEntities.createHarpoon(AlaskaItems.WOODEN_HARPOON));
    public static final class_1299<HarpoonEntity> STONE_HARPOON = AlaskaEntities.add("stone_harpoon", AlaskaEntities.createHarpoon(AlaskaItems.STONE_HARPOON));
    public static final class_1299<HarpoonEntity> IRON_HARPOON = AlaskaEntities.add("iron_harpoon", AlaskaEntities.createHarpoon(AlaskaItems.IRON_HARPOON));
    public static final class_1299<HarpoonEntity> GOLDEN_HARPOON = AlaskaEntities.add("golden_harpoon", AlaskaEntities.createHarpoon(AlaskaItems.GOLDEN_HARPOON));
    public static final class_1299<HarpoonEntity> DIAMOND_HARPOON = AlaskaEntities.add("diamond_harpoon", AlaskaEntities.createHarpoon(AlaskaItems.DIAMOND_HARPOON));
    public static final class_1299<HarpoonEntity> NETHERITE_HARPOON = AlaskaEntities.add("netherite_harpoon", AlaskaEntities.createHarpoon(AlaskaItems.NETHERITE_HARPOON));

    public static void register() {
        for (class_2960 id : ENTITY_TYPES.keySet()) {
            class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)id, ENTITY_TYPES.get(id));
        }
        AlaskaEntities.initAttributes();
        AlaskaEntities.initSpawns();
        AlaskaEntities.initSpawnRestrictions();
    }

    private static void initSpawnRestrictions() {
        SpawnRestrictionAccessor.callRegister(HARP_SEAL, (class_1317.class_1319)class_1317.class_1319.field_6318, (class_2902.class_2903)class_2902.class_2903.field_13203, SealEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister(MOOSE, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, class_1429::method_20663);
        SpawnRestrictionAccessor.callRegister(PTARMIGAN, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13197, PtarmiganEntity::isValidSpawn);
    }

    private static void initAttributes() {
        FabricDefaultAttributeRegistry.register(HARP_SEAL, (class_5132.class_5133)SealEntity.createSealAttributes());
        FabricDefaultAttributeRegistry.register(PTARMIGAN, (class_5132.class_5133)PtarmiganEntity.createPtarmiganAttributes());
        FabricDefaultAttributeRegistry.register(MOOSE, (class_5132.class_5133)MooseEntity.createMooseAttributes());
    }

    private static void initSpawns() {
        AlaskaConfig.SpawnOptions spawnOptions = AlaskaConfig.getConfig().spawning;
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9367}), (class_1311)class_1311.field_6300, HARP_SEAL, (int)spawnOptions.sealOceanSettings.weight, (int)spawnOptions.sealOceanSettings.minGroupSize, (int)spawnOptions.sealOceanSettings.maxGroupSize);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9369}), (class_1311)class_1311.field_6300, HARP_SEAL, (int)spawnOptions.sealRiverSettings.weight, (int)spawnOptions.sealRiverSettings.minGroupSize, (int)spawnOptions.sealRiverSettings.maxGroupSize);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9361, class_1959.class_1961.field_9362, class_1959.class_1961.field_9370}), (class_1311)class_1311.field_6294, MOOSE, (int)spawnOptions.mooseSettings.weight, (int)spawnOptions.mooseSettings.minGroupSize, (int)spawnOptions.mooseSettings.maxGroupSize);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9361, class_1959.class_1961.field_9362, class_1959.class_1961.field_9370}), (class_1311)class_1311.field_6303, PTARMIGAN, (int)spawnOptions.ptarmiganSettings.weight, (int)spawnOptions.ptarmiganSettings.minGroupSize, (int)spawnOptions.ptarmiganSettings.maxGroupSize);
    }

    private static <E extends class_1299<?>> E add(String name, E type) {
        class_2960 id = new class_2960("alaskanativecraft", name);
        ENTITY_TYPES.put(id, type);
        return type;
    }

    private static class_1299<HarpoonEntity> createHarpoon(HarpoonItem item) {
        return FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, (entity, world) -> new HarpoonEntity((class_1299<? extends HarpoonEntity>)entity, world, item)).dimensions(class_4048.method_18385((float)0.5f, (float)0.5f)).build();
    }

    private static <T extends class_1297> class_1299<T> createEntity(class_1311 group, class_1299.class_4049<T> factory, boolean changingDimensions, float width, float height) {
        if (changingDimensions) {
            return FabricEntityTypeBuilder.create((class_1311)group, factory).dimensions(class_4048.method_18384((float)width, (float)height)).build();
        }
        return FabricEntityTypeBuilder.create((class_1311)group, factory).dimensions(class_4048.method_18385((float)width, (float)height)).build();
    }
}

