/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.entity;

import com.github.platymemo.alaskanativecraft.item.HarpoonItem;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HarpoonEntity
extends class_1665 {
    public static final class_2960 SPAWN_PACKET = new class_2960("alaskanativecraft", "harpoon_entity");
    private static final class_2940<Byte> LOYALTY;
    private static final class_2940<Boolean> ENCHANTED;
    public int returnTimer;
    private class_1799 harpoonStack;
    private State state;
    private boolean dealtDamage;

    public HarpoonEntity(class_1299<? extends HarpoonEntity> entityType, class_1937 world, HarpoonItem item) {
        super(entityType, world);
        this.state = State.FLYING;
        this.harpoonStack = new class_1799((class_1935)item);
    }

    public HarpoonEntity(class_1937 world, class_1309 owner, @NotNull HarpoonItem item, @NotNull class_1799 stack) {
        super(item.getType(), owner, world);
        this.harpoonStack = stack.method_7972();
        this.state = State.FLYING;
        this.field_6011.method_12778(LOYALTY, (Object)((byte)class_1890.method_8206((class_1799)stack)));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
    }

    public static class_1282 createHarpoonDamageSource(class_1297 harpoon, class_1297 owner) {
        return new class_1284("harpoon", harpoon, owner).method_5517();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LOYALTY, (Object)0);
        this.field_6011.method_12784(ENCHANTED, (Object)false);
    }

    public class_2596<?> method_18002() {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10804(class_2378.field_11145.method_10206((Object)this.method_5864()));
        packet.method_10797(this.method_5667());
        packet.method_10804(this.method_5628());
        packet.writeDouble(this.method_23317());
        packet.writeDouble(this.method_23318());
        packet.writeDouble(this.method_23321());
        packet.writeByte(class_3532.method_15375((float)(this.method_36455() * 256.0f / 360.0f)));
        packet.writeByte(class_3532.method_15375((float)(this.method_36454() * 256.0f / 360.0f)));
        return ServerPlayNetworking.createS2CPacket((class_2960)SPAWN_PACKET, (class_2540)packet);
    }

    protected class_1799 method_7445() {
        return this.harpoonStack.method_7972();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isEnchanted() {
        return (Boolean)this.field_6011.method_12789(ENCHANTED);
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    public void method_5773() {
        double d;
        if (this.state == State.BOBBING) {
            float fluidHeight = 0.0f;
            class_2338 blockPos = this.method_24515();
            class_3610 fluidState = this.field_6002.method_8316(blockPos);
            if (fluidState.method_15767((class_3494)class_3486.field_15517)) {
                fluidHeight = fluidState.method_15763((class_1922)this.field_6002, blockPos);
            }
            class_243 vec3d = this.method_18798();
            double distanceFromLiquidHeight = this.method_23318() + vec3d.field_1351 - (double)blockPos.method_10264() - (double)fluidHeight;
            if (vec3d.field_1351 > 0.032) {
                this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)vec3d.method_37267()) * 57.2957763671875));
                this.method_36457(HarpoonEntity.method_26960((float)this.field_6004, (float)this.method_36455()));
            } else {
                this.method_36457(HarpoonEntity.method_26960((float)this.field_6004, (float)0.0f));
            }
            if (Math.abs(distanceFromLiquidHeight) < 0.01) {
                distanceFromLiquidHeight += Math.signum(distanceFromLiquidHeight) * 0.1;
            }
            this.method_18800(vec3d.field_1352 * 0.9, vec3d.field_1351 - distanceFromLiquidHeight * (double)this.field_5974.nextFloat() * 0.2, vec3d.field_1350 * 0.9);
            vec3d = this.method_18798();
            this.method_5814(this.method_23317() + vec3d.field_1352, this.method_23318() + vec3d.field_1351, this.method_23321() + vec3d.field_1350);
            this.method_5852();
            return;
        }
        if (this.field_7576 > 4) {
            this.dealtDamage = true;
        }
        class_1297 entity = this.method_24921();
        if ((this.dealtDamage || this.method_7441()) && entity != null) {
            byte i = (Byte)this.field_6011.method_12789(LOYALTY);
            if (i > 0 && !entity.method_5805()) {
                if (!this.field_6002.field_9236 && this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.method_31472();
            } else if (i > 0) {
                this.method_7433(true);
                class_243 vec3d = new class_243(entity.method_23317() - this.method_23317(), entity.method_23320() - this.method_23318(), entity.method_23321() - this.method_23321());
                this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * (double)i, this.method_23321());
                if (this.field_6002.field_9236) {
                    this.field_5971 = this.method_23318();
                }
                d = 0.05 * (double)i;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
                if (this.returnTimer == 0) {
                    this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        super.method_5773();
        boolean inWater = this.method_5799();
        if (this.field_7588 && this.state != State.LANDED) {
            this.state = State.LANDED;
            return;
        }
        if (!inWater || this.state != State.FLYING) {
            return;
        }
        class_243 velocity = this.method_18798();
        d = velocity.field_1352;
        double e = velocity.field_1351 + 0.05;
        double g = velocity.field_1350;
        this.method_18800(d, e, g);
        double h = this.method_23317() - d;
        double j = this.method_23318() - e;
        double k = this.method_23321() - g;
        float f = 0.0f;
        class_2338 blockPos = this.method_24515();
        class_3610 fluidState = this.field_6002.method_8316(blockPos);
        if (fluidState.method_15767((class_3494)class_3486.field_15517)) {
            f = fluidState.method_15763((class_1922)this.field_6002, blockPos);
        }
        velocity = this.method_18798();
        double distanceFromLiquidHeight = this.method_23318() + velocity.field_1351 - (double)blockPos.method_10264() - (double)f;
        if (distanceFromLiquidHeight > 0.0 && velocity.method_1033() < 1.0) {
            this.state = State.BOBBING;
        } else {
            this.method_18800(velocity.field_1352, velocity.field_1351 + 0.025, velocity.field_1350);
        }
        velocity = this.method_18798().method_1021((double)this.method_7436());
        this.method_5814(h += velocity.field_1352, j += velocity.field_1351, k += velocity.field_1350);
        this.method_5852();
    }

    protected void method_5852() {
        super.method_5852();
        if (this.field_7588) {
            this.state = State.LANDED;
        }
    }

    protected void method_7454(@NotNull class_3966 entityHitResult) {
        class_2338 blockPos;
        class_1297 owner;
        class_1297 hitEntity = entityHitResult.method_17782();
        float f = ((HarpoonItem)this.harpoonStack.method_7909()).getAttackDamage();
        if (hitEntity instanceof class_1309) {
            class_1309 livingHitEntity = (class_1309)hitEntity;
            f += class_1890.method_8218((class_1799)this.harpoonStack, (class_1310)livingHitEntity.method_6046());
        }
        class_1282 damageSource = HarpoonEntity.createHarpoonDamageSource((class_1297)this, (class_1297)((owner = this.method_24921()) == null ? this : owner));
        this.dealtDamage = true;
        class_3414 soundEvent = class_3417.field_15213;
        if (hitEntity.method_5643(damageSource, f)) {
            if (hitEntity.method_5864() == class_1299.field_6091) {
                return;
            }
            if (hitEntity instanceof class_1309) {
                class_1309 livingHitEntity = (class_1309)hitEntity;
                if (owner instanceof class_1309) {
                    class_1890.method_8210((class_1309)livingHitEntity, (class_1297)owner);
                    class_1890.method_8213((class_1309)((class_1309)owner), (class_1297)livingHitEntity);
                }
                this.method_7450(livingHitEntity);
                if (hitEntity instanceof class_1308 && this.method_24921() instanceof class_1657 && !((class_1308)hitEntity).method_5934() && this.harpoonStack.method_7948().method_10545("leashed") && this.harpoonStack.method_7948().method_10577("leashed")) {
                    ((class_1308)hitEntity).method_5954(this.method_24921(), true);
                    this.harpoonStack.method_7983("leashed");
                    this.method_18799(class_243.field_1353);
                    this.method_5783(soundEvent, 1.0f, 1.0f);
                    return;
                }
            }
        }
        float g = 1.0f;
        if (this.field_6002 instanceof class_3218 && this.field_6002.method_8546() && class_1890.method_8228((class_1799)this.harpoonStack) && this.field_6002.method_8311(blockPos = hitEntity.method_24515())) {
            class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883(this.field_6002);
            lightningEntity.method_29495(class_243.method_24955((class_2382)blockPos));
            lightningEntity.method_6961(owner instanceof class_3222 ? (class_3222)owner : null);
            this.field_6002.method_8649((class_1297)lightningEntity);
            soundEvent = class_3417.field_14896;
            g = 5.0f;
        }
        this.method_5783(soundEvent, g, 1.0f);
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        this.method_5783(soundEvent, 1.0f, 1.0f);
    }

    protected class_3414 method_7440() {
        return class_3417.field_15104;
    }

    public void method_5694(class_1657 player) {
        class_1297 entity = this.method_24921();
        if (entity == null || entity.method_5667() == player.method_5667()) {
            if (this.state != State.FLYING && !this.field_6002.field_9236 && (this.state == State.BOBBING || this.method_7441()) && this.field_7574 <= 0) {
                boolean bl;
                boolean bl2 = bl = this.field_7572 == class_1665.class_1666.field_7593 || this.field_7572 == class_1665.class_1666.field_7594 && player.method_31549().field_7477 || this.method_7441() && this.method_24921().method_5667() == player.method_5667();
                if (this.field_7572 == class_1665.class_1666.field_7593 && !player.method_31548().method_7394(this.method_7445())) {
                    bl = false;
                }
                if (bl) {
                    player.method_6103((class_1297)this, 1);
                    this.method_31472();
                }
            } else {
                super.method_5694(player);
            }
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10573("Trident", 10)) {
            this.harpoonStack = class_1799.method_7915((class_2487)tag.method_10562("Harpoon"));
        }
        this.dealtDamage = tag.method_10577("DealtDamage");
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10566("Harpoon", (class_2520)this.harpoonStack.method_7953(new class_2487()));
        tag.method_10556("DealtDamage", this.dealtDamage);
    }

    public void method_7446() {
        if (this.field_7572 != class_1665.class_1666.field_7593) {
            super.method_7446();
        }
    }

    protected float method_7436() {
        return 0.9f;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    static {
        ENCHANTED = class_2945.method_12791(HarpoonEntity.class, (class_2941)class_2943.field_13323);
        LOYALTY = class_2945.method_12791(HarpoonEntity.class, (class_2941)class_2943.field_13319);
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING,
        LANDED;

    }
}

