/*
 * Decompiled with CFR 0.152.
 */
package com.github.platymemo.alaskanativecraft.feature;

import com.github.platymemo.alaskanativecraft.block.AlaskaBlocks;
import com.github.platymemo.alaskanativecraft.config.AlaskaConfig;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3175;
import net.minecraft.class_3830;
import net.minecraft.class_4651;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5458;
import net.minecraft.class_6792;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import org.jetbrains.annotations.NotNull;

public class AlaskaFeatures {
    public static void register() {
        AlaskaConfig.GenerationOptions genOptions = AlaskaConfig.getConfig().generation;
        if (genOptions.genBlueberry) {
            AlaskaFeatures.registerBerryPatch((class_2248)AlaskaBlocks.BLUEBERRY_BUSH, "blueberry_bush");
        }
        if (genOptions.genCloudberry) {
            AlaskaFeatures.registerBerryPatch((class_2248)AlaskaBlocks.CLOUDBERRY_BUSH, "cloudberry_bush");
        }
        if (genOptions.genRaspberry) {
            AlaskaFeatures.registerBerryPatch((class_2248)AlaskaBlocks.RASPBERRY_BUSH, "raspberry_bush");
        }
        if (genOptions.genSalmonberry) {
            AlaskaFeatures.registerBerryPatch((class_2248)AlaskaBlocks.SALMONBERRY_BUSH, "salmonberry_bush");
        }
        if (genOptions.genDriftwood) {
            AlaskaFeatures.registerPatch(AlaskaBlocks.DRIFTWOOD_LOG.method_9564(), "washed_up_driftwood", class_1959.class_1961.field_9363, class_2246.field_10219, class_2246.field_10255, class_2246.field_10460, class_2246.field_10102, class_2246.field_10534);
        }
    }

    private static void registerBerryPatch(@NotNull class_2248 berryBush, String bushName) {
        AlaskaFeatures.registerPatch((class_2680)berryBush.method_9564().method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(3)), bushName, class_1959.class_1961.field_9361, class_2246.field_10219);
    }

    private static void registerPatch(class_2680 blockState, String featureName, class_1959.class_1961 biomeCategory, class_2248 ... whitelist) {
        class_2975 patchFeature = class_3031.field_21220.method_23397((class_3037)class_6803.method_39706((class_2975)class_3031.field_13518.method_23397((class_3037)new class_3175((class_4651)class_4651.method_38433((class_2680)blockState))), List.of(whitelist), (int)64));
        class_6796 sparsePatch = patchFeature.method_39594(new class_6797[]{class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614()});
        class_5321 sparsePatchRegistryKey = class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)new class_2960("alaskanativecraft", "patch_" + featureName + "_sparse"));
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)sparsePatchRegistryKey.method_29177(), (Object)sparsePatch);
        BiomeModifications.addFeature(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{biomeCategory}).and(ctx -> !AlaskaConfig.getConfig().generation.snowyGen).and(ctx -> ctx.getBiome().method_8694() == class_1959.class_1963.field_9382), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)sparsePatchRegistryKey);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9362}), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)sparsePatchRegistryKey);
        class_6796 decoratedPatch = patchFeature.method_39594(new class_6797[]{class_6799.method_39659((int)32), class_5450.method_39639(), class_6817.field_36080, class_6792.method_39614()});
        class_5321 decoratedPatchRegistryKey = class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)new class_2960("alaskanativecraft", "patch_" + featureName + "_decorated"));
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)decoratedPatchRegistryKey.method_29177(), (Object)decoratedPatch);
        BiomeModifications.addFeature(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{biomeCategory}).and(ctx -> ctx.getBiome().method_8694() == class_1959.class_1963.field_9383), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)decoratedPatchRegistryKey);
    }
}

