/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import gcewing.lighting.Trans3;
import gcewing.lighting.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseBlockRenderer<BLOCK extends Block>
implements ISimpleBlockRenderingHandler {
    public int renderID;
    Tessellator tess;
    IBlockAccess world;
    BLOCK block;
    int blockX;
    int blockY;
    int blockZ;
    int metadata;
    double u0;
    double v0;
    double u1;
    double v1;
    double us;
    double vs;
    boolean textureOverridden;
    float cmr;
    float cmg;
    float cmb;
    int blockBrightness;
    public static double[][] cubeFaces = new double[][]{{-0.5, -0.5, 0.5, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0}, {-0.5, 0.5, -0.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.5, 0.5, -0.5, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0}, {-0.5, 0.5, 0.5, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {-0.5, 0.5, -0.5, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0}, {0.5, 0.5, 0.5, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}};

    public int getRenderId() {
        return this.renderID;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks rb) {
        this.world = null;
        this.block = block;
        this.blockX = 0;
        this.blockY = 0;
        this.blockZ = 0;
        this.setUpTextureOverride(rb);
        this.metadata = metadata;
        this.blockBrightness = 0xF000F0;
        this.setColorMultiplier(0xFFFFFF);
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        Trans3 t = this.localToInventoryTransformation(metadata);
        this.tess.func_78382_b();
        this.renderBlock(t);
        this.tess.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int renderID, RenderBlocks rb) {
        this.world = world;
        this.block = block;
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        this.setUpTextureOverride(rb);
        this.metadata = world.func_72805_g(x, y, z);
        this.blockBrightness = block.func_149677_c(world, x, y, z);
        this.setColorMultiplier(block.func_149720_d(world, x, y, z));
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        Trans3 t = this.localToGlobalTransformation();
        return this.renderBlock(t);
    }

    Trans3 localToInventoryTransformation(int metadata) {
        return new Trans3(0.0, 0.0, 0.0);
    }

    Trans3 localToGlobalTransformation() {
        return new Trans3((double)this.blockX + 0.5, (double)this.blockY + 0.5, (double)this.blockZ + 0.5);
    }

    boolean renderBlock(Trans3 t) {
        this.renderCube(t);
        return true;
    }

    void setColorMultiplier(int color) {
        this.cmr = (float)(color >> 16 & 0xFF) / 255.0f;
        this.cmg = (float)(color >> 8 & 0xFF) / 255.0f;
        this.cmb = (float)(color & 0xFF) / 255.0f;
    }

    void setUpTextureOverride(RenderBlocks rb) {
        IIcon icon;
        this.textureOverridden = false;
        if (rb != null && (icon = rb.field_147840_d) != null) {
            this.useIcon(icon);
            this.textureOverridden = true;
        }
    }

    void selectTile(IIcon icon) {
        this.selectTile(icon, 16.0, 16.0);
    }

    void selectTile(IIcon icon, double width, double height) {
        if (!this.textureOverridden) {
            this.useIcon(icon);
        }
        this.us = (this.u1 - this.u0) / width;
        this.vs = (this.v1 - this.v0) / height;
    }

    void useIcon(IIcon icon) {
        this.u0 = icon.func_94209_e();
        this.v0 = icon.func_94206_g();
        this.u1 = icon.func_94212_f();
        this.v1 = icon.func_94210_h();
    }

    void renderCube(Trans3 t) {
        this.renderCubeWithFaceDepths(t, null);
    }

    void renderCubeWithFaceDepths(Trans3 t, double[] faceDepths) {
        for (int i = 0; i < 6; ++i) {
            this.selectTileForSide(i);
            this.setBrightnessForSide(t, i);
            this.cubeFace(t, cubeFaces[i]);
            if (faceDepths == null) continue;
            this.tess.func_78380_c(this.blockBrightness);
            this.cubeBackFace(t, cubeFaces[i], faceDepths[i]);
        }
    }

    void selectTileForSide(int side) {
        this.selectTile(this.block.func_149691_a(side, this.metadata));
    }

    void setBrightnessForSide(Trans3 t, int side) {
        if (this.world != null) {
            ForgeDirection d = ForgeDirection.getOrientation((int)side);
            Vector3 p = t.p(d.offsetX, d.offsetY, d.offsetZ);
            this.tess.func_78380_c(this.block.func_149677_c(this.world, p.floorX(), p.floorY(), p.floorZ()));
        } else {
            this.setBrightnessForBlock();
        }
    }

    void setBrightnessForBlock() {
        this.tess.func_78380_c(this.blockBrightness);
    }

    void setNormal(Trans3 t, double nx, double ny, double nz) {
        this.setNormal(t, nx, ny, nz, 1.0);
    }

    void setNormal(Trans3 t, double nx, double ny, double nz, double shade) {
        Vector3 n = t.v(nx, ny, nz);
        float bm = (float)(shade * (0.6 * n.x * n.x + 0.8 * n.z * n.z + (n.y > 0.0 ? 1.0 : 0.5) * n.y * n.y));
        this.tess.func_78375_b((float)n.x, (float)n.y, (float)n.z);
        this.tess.func_78386_a(bm * this.cmr, bm * this.cmg, bm * this.cmb);
    }

    void cubeFace(Trans3 t, double[] c) {
        this.setNormal(t, c[9], c[10], c[11]);
        this.face(t, c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7], c[8], 0.0, 0.0, 16.0, 16.0);
    }

    void cubeBackFace(Trans3 t, double[] c, double d) {
        double nx = -c[9];
        double ny = -c[10];
        double nz = -c[11];
        this.setNormal(t, nx, ny, nz, 0.5);
        this.backFace(t, c[0] + d * nx, c[1] + d * ny, c[2] + d * nz, c[3], c[4], c[5], c[6], c[7], c[8], 0.0, 0.0, 16.0, 16.0);
    }

    void face(Trans3 t, double x, double y, double z, double dx1, double dy1, double dz1, double dx2, double dy2, double dz2, double u, double v, double du, double dv) {
        this.vertex(t, x, y, z, u, v);
        this.vertex(t, x + dx1, y + dy1, z + dz1, u, v + dv);
        this.vertex(t, x + dx1 + dx2, y + dy1 + dy2, z + dz1 + dz2, u + du, v + dv);
        this.vertex(t, x + dx2, y + dy2, z + dz2, u + du, v);
    }

    void backFace(Trans3 t, double x, double y, double z, double dx1, double dy1, double dz1, double dx2, double dy2, double dz2, double u, double v, double du, double dv) {
        this.face(t, x + dx1, y + dy1, z + dz1, -dx1, -dy1, -dz1, dx2, dy2, dz2, u, v + dv, du, -dv);
    }

    void vertex(Trans3 t, double x, double y, double z, double u, double v) {
        Vector3 p = t.p(x, y, z);
        this.tess.func_78374_a(p.x, p.y, p.z, this.u0 + u * this.us, this.v0 + v * this.vs);
    }

    void renderBox(Trans3 t, AxisAlignedBB box, IIcon[] icons) {
        this.renderBox(t, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d - box.field_72340_a, box.field_72337_e - box.field_72338_b, box.field_72334_f - box.field_72339_c, icons);
    }

    void renderBox(Trans3 t, double x0, double y0, double z0, double dx, double dy, double dz, IIcon[] icons) {
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        double z1 = z0 + dz;
        this.tess.func_78380_c(this.blockBrightness);
        this.boxFace(t, x0, y0, z1, 0.0, 0.0, -dz, dx, 0.0, 0.0, 0.0, -1.0, 0.0, dx, dz, icons[0]);
        this.boxFace(t, x0, y1, z0, 0.0, 0.0, dz, dx, 0.0, 0.0, 0.0, 1.0, 0.0, dx, dz, icons[1]);
        this.boxFace(t, x1, y1, z0, 0.0, -dy, 0.0, -dx, 0.0, 0.0, 0.0, 0.0, -1.0, dx, dy, icons[2]);
        this.boxFace(t, x0, y1, z1, 0.0, -dy, 0.0, dx, 0.0, 0.0, 0.0, 0.0, 1.0, dx, dy, icons[3]);
        this.boxFace(t, x0, y1, z0, 0.0, -dy, 0.0, 0.0, 0.0, dz, -1.0, 0.0, 0.0, dz, dy, icons[4]);
        this.boxFace(t, x1, y1, z1, 0.0, -dy, 0.0, 0.0, 0.0, -dz, 1.0, 0.0, 0.0, dz, dy, icons[5]);
    }

    void boxFace(Trans3 t, double x, double y, double z, double dx1, double dy1, double dz1, double dx2, double dy2, double dz2, double nx, double ny, double nz, double du, double dv, IIcon icon) {
        if (icon != null) {
            this.selectTile(icon);
            this.setNormal(t, nx, ny, nz);
            this.face(t, x, y, z, dx1, dy1, dz1, dx2, dy2, dz2, 0.0, 0.0, du * 16.0, dv * 16.0);
        }
    }
}

