/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.BaseContainer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class BaseGuiContainer
extends GuiContainer {
    static final int defaultTextColor = 0x404040;
    double uscale;
    double vscale;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    public int textColor = 0x404040;
    public boolean textShadow = false;

    public BaseGuiContainer(Container container, int width, int height) {
        super(container);
        this.field_146999_f = width;
        this.field_147000_g = height;
    }

    public BaseGuiContainer(BaseContainer container) {
        this(container, container.xSize, container.ySize);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.resetColor();
        this.textColor = 0x404040;
        this.textShadow = false;
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.drawBackgroundLayer();
        GL11.glPopMatrix();
    }

    protected void drawBackgroundLayer() {
    }

    protected void func_146979_b(int par1, int par2) {
        this.drawForegroundLayer();
    }

    protected void drawForegroundLayer() {
    }

    void close() {
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    public void bindTexture(ResourceLocation rsrc) {
        this.bindTexture(rsrc, 1, 1);
    }

    public void bindTexture(ResourceLocation rsrc, int usize, int vsize) {
        this.field_146297_k.func_110434_K().func_110577_a(rsrc);
        this.uscale = 1.0 / (double)usize;
        this.vscale = 1.0 / (double)vsize;
    }

    public void drawRect(double x, double y, double w, double h) {
        GL11.glDisable((int)3553);
        GL11.glColor3d((double)this.red, (double)this.green, (double)this.blue);
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)x, (double)(y + h), (double)this.field_73735_i);
        GL11.glVertex3d((double)(x + w), (double)(y + h), (double)this.field_73735_i);
        GL11.glVertex3d((double)(x + w), (double)y, (double)this.field_73735_i);
        GL11.glVertex3d((double)x, (double)y, (double)this.field_73735_i);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public void drawTexturedRect(double x, double y, double w, double h) {
        this.drawTexturedRectUV(x, y, w, h, 0.0, 0.0, 1.0, 1.0);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v) {
        this.drawTexturedRect(x, y, w, h, u, v, w, h);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v, double us, double vs) {
        this.drawTexturedRectUV(x, y, w, h, u * this.uscale, v * this.vscale, us * this.uscale, vs * this.vscale);
    }

    public void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(this.red, this.green, this.blue);
        tess.func_78374_a(x, y + h, (double)this.field_73735_i, u, v + vs);
        tess.func_78374_a(x + w, y + h, (double)this.field_73735_i, u + us, v + vs);
        tess.func_78374_a(x + w, y, (double)this.field_73735_i, u + us, v);
        tess.func_78374_a(x, y, (double)this.field_73735_i, u, v);
        tess.func_78381_a();
    }

    public void setColor(int hex) {
        this.setColor((double)(hex >> 16) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
    }

    public void setColor(double r, double g, double b) {
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
    }

    public void resetColor() {
        this.setColor(1.0, 1.0, 1.0);
    }

    public void drawString(String s, int x, int y) {
        this.field_146289_q.func_85187_a(s, x, y, this.textColor, this.textShadow);
    }

    public void drawCenteredString(String s, int x, int y) {
        this.field_146289_q.func_85187_a(s, x - this.field_146289_q.func_78256_a(s) / 2, y, this.textColor, this.textShadow);
    }

    public void drawRightAlignedString(String s, int x, int y) {
        this.field_146289_q.func_85187_a(s, x - this.field_146289_q.func_78256_a(s), y, this.textColor, this.textShadow);
    }

    public void drawInventoryName(IInventory inv, int x, int y) {
        this.drawString(BaseGuiContainer.inventoryName(inv), x, y);
    }

    public void drawPlayerInventoryName() {
        this.drawString(BaseGuiContainer.playerInventoryName(), 8, this.field_147000_g - 96 + 2);
    }

    public static String inventoryName(IInventory inv) {
        String name = inv.func_145825_b();
        if (!inv.func_145818_k_()) {
            name = StatCollector.func_74838_a((String)name);
        }
        return name;
    }

    public static String playerInventoryName() {
        return StatCollector.func_74838_a((String)"container.inventory");
    }
}

