/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gcewing.lighting.BaseConfiguration;
import gcewing.lighting.BaseModClient;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BaseMod
implements IGuiHandler {
    public String modID;
    public BaseConfiguration config;
    public String modPackage;
    public String assetKey;
    public String resourceDir;
    public URL resourceURL;
    public BaseModClient client;
    public IGuiHandler proxy;
    public boolean serverSide;
    public boolean clientSide;
    public CreativeTabs creativeTab = CreativeTabs.field_78026_f;
    public boolean debugGui;
    File cfgFile;
    List<IBlock> registeredBlocks = new ArrayList<IBlock>();
    public List<VSBinding> registeredVillagers = new ArrayList<VSBinding>();
    Map<Integer, Class<? extends Container>> containerClasses = new HashMap<Integer, Class<? extends Container>>();

    public String resourcePath(String fileName) {
        return this.resourceDir + fileName;
    }

    public BaseMod() {
        Class<?> modClass = this.getClass();
        this.modPackage = modClass.getPackage().getName();
        this.assetKey = this.modPackage.replace(".", "_");
        this.modID = BaseMod.getModID(modClass);
        String resourceRelDir = "assets/" + this.assetKey + "/";
        this.resourceDir = "/" + resourceRelDir;
        this.resourceURL = this.getClass().getClassLoader().getResource(resourceRelDir);
    }

    static String getModID(Class cls) {
        Mod ann = cls.getAnnotation(Mod.class);
        if (ann instanceof Mod) {
            return ann.modid();
        }
        System.out.printf("BaseMod: Mod annotation not found\n", new Object[0]);
        return "<unknown>";
    }

    public static boolean isModLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public void preInit(FMLPreInitializationEvent e) {
        this.serverSide = e.getSide().isServer();
        this.clientSide = e.getSide().isClient();
        if (this.clientSide) {
            this.client = this.initClient();
            this.proxy = this.client;
        }
        this.cfgFile = e.getSuggestedConfigurationFile();
        this.loadConfig();
        this.configure();
        if (this.client != null) {
            this.client.preInit(e);
        }
        this.registerBlocks();
        this.registerTileEntities();
        this.registerItems();
        this.registerOres();
    }

    public void init(FMLInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (this.client != null) {
            this.client.init(e);
        }
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.registerRecipes();
        this.registerRandomItems();
        this.registerWorldGenerators();
        this.registerContainers();
        this.registerEntities();
        this.registerVillagers();
        this.registerOther();
        if (this.client != null) {
            this.client.postInit(e);
        }
        if (this.proxy == null) {
            this.proxy = this;
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, this.proxy);
        this.saveConfig();
    }

    void loadConfig() {
        this.config = new BaseConfiguration(this.cfgFile);
    }

    void saveConfig() {
        if (this.config.extended) {
            this.config.save();
        }
    }

    String qualifiedName(String name) {
        return this.modPackage + "." + name;
    }

    void configure() {
    }

    BaseModClient initClient() {
        return new BaseModClient(this);
    }

    public Item newItem(String name) {
        return this.newItem(name, Item.class);
    }

    public <ITEM extends Item> ITEM newItem(String name, Class<ITEM> cls) {
        Item item;
        try {
            Constructor<ITEM> ctor = cls.getConstructor(new Class[0]);
            item = (Item)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (ITEM)this.addItem(item, name);
    }

    public <ITEM extends Item> ITEM addItem(ITEM item, String name) {
        String qualName = this.assetKey + ":" + name;
        item.func_77655_b(qualName);
        item.func_111206_d(qualName);
        GameRegistry.registerItem(item, (String)name);
        if (this.creativeTab != null) {
            item.func_77637_a(this.creativeTab);
        }
        return item;
    }

    public Block newBlock(String name) {
        return this.newBlock(name, Block.class);
    }

    public <BLOCK extends Block> BLOCK newBlock(String name, Class<BLOCK> cls) {
        return this.newBlock(name, cls, ItemBlock.class);
    }

    public <BLOCK extends Block> BLOCK newBlock(String name, Class<BLOCK> cls, Class itemClass) {
        Block block;
        try {
            Constructor<BLOCK> ctor = cls.getConstructor(new Class[0]);
            block = (Block)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (BLOCK)this.addBlock(block, name, itemClass);
    }

    public <BLOCK extends Block> BLOCK addBlock(BLOCK block, String name) {
        return this.addBlock(block, name, ItemBlock.class);
    }

    public <BLOCK extends Block> BLOCK addBlock(BLOCK block, String name, Class itemClass) {
        String qualName = this.assetKey + ":" + name;
        block.func_149663_c(qualName);
        block.func_149658_d(qualName);
        System.out.printf("BaseMod.addBlock: name '%s' qualName '%s' %s\n", name, qualName, block);
        GameRegistry.registerBlock(block, (Class)itemClass, (String)name);
        if (this.creativeTab != null) {
            block.func_149647_a(this.creativeTab);
        }
        if (block instanceof IBlock) {
            this.registeredBlocks.add((IBlock)block);
        }
        return block;
    }

    public void addOre(String name, Block block) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(block));
    }

    public void addOre(String name, Item item) {
        OreDictionary.registerOre((String)name, (Item)item);
    }

    public static boolean blockMatchesOre(Block block, String name) {
        return BaseMod.stackMatchesOre(new ItemStack(block), name);
    }

    public static boolean itemMatchesOre(Item item, String name) {
        return BaseMod.stackMatchesOre(new ItemStack(item), name);
    }

    public static boolean stackMatchesOre(ItemStack stack, String name) {
        int id = OreDictionary.getOreID((ItemStack)stack);
        return id == OreDictionary.getOreID((String)name);
    }

    public void newRecipe(Item product, int qty, Object ... params) {
        this.newRecipe(new ItemStack(product, qty), params);
    }

    public void newRecipe(Block product, int qty, Object ... params) {
        this.newRecipe(new ItemStack(product, qty), params);
    }

    public void newRecipe(ItemStack product, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(product, params));
    }

    public void newShapelessRecipe(Block product, int qty, Object ... params) {
        this.newShapelessRecipe(new ItemStack(product, qty), params);
    }

    public void newShapelessRecipe(Item product, int qty, Object ... params) {
        this.newShapelessRecipe(new ItemStack(product, qty), params);
    }

    public void newShapelessRecipe(ItemStack product, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(product, params));
    }

    public void newSmeltingRecipe(Item product, int qty, Item input) {
        this.newSmeltingRecipe(product, qty, input, 0);
    }

    public void newSmeltingRecipe(Item product, int qty, Item input, int xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)new ItemStack(product, qty), (float)xp);
    }

    public void newSmeltingRecipe(Item product, int qty, Block input) {
        this.newSmeltingRecipe(product, qty, input, 0);
    }

    public void newSmeltingRecipe(Item product, int qty, Block input, int xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)new ItemStack(product, qty), (float)xp);
    }

    public void addRandomChestItem(ItemStack stack, int minQty, int maxQty, int weight, String ... category) {
        WeightedRandomChestContent item = new WeightedRandomChestContent(stack, minQty, maxQty, weight);
        for (int i = 0; i < category.length; ++i) {
            ChestGenHooks.addItem((String)category[i], (WeightedRandomChestContent)item);
        }
    }

    public void addEntity(Class<? extends Entity> cls, String name, Enum id) {
        this.addEntity(cls, name, id.ordinal());
    }

    public void addEntity(Class<? extends Entity> cls, String name, int id) {
        this.addEntity(cls, name, id, 1, true);
    }

    public void addEntity(Class<? extends Entity> cls, String name, Enum id, int updateFrequency, boolean sendVelocityUpdates) {
        this.addEntity(cls, name, id.ordinal(), updateFrequency, sendVelocityUpdates);
    }

    public void addEntity(Class<? extends Entity> cls, String name, int id, int updateFrequency, boolean sendVelocityUpdates) {
        System.out.printf("%s: BaseMod.registerEntity: %s, \"%s\", %s\n", this.getClass().getSimpleName(), cls.getSimpleName(), name, id);
        EntityRegistry.registerModEntity(cls, (String)name, (int)id, (Object)this, (int)256, (int)updateFrequency, (boolean)sendVelocityUpdates);
    }

    int addVillager(String name, ResourceLocation skin) {
        int id = this.config.getVillager(name);
        VSBinding b = new VSBinding();
        b.id = id;
        b.object = skin;
        this.registeredVillagers.add(b);
        return id;
    }

    void addTradeHandler(int villagerID, VillagerRegistry.IVillageTradeHandler handler) {
        VillagerRegistry.instance().registerVillageTradeHandler(villagerID, handler);
    }

    void registerBlocks() {
    }

    void registerItems() {
    }

    void registerOres() {
    }

    void registerRecipes() {
    }

    void registerTileEntities() {
    }

    void registerRandomItems() {
    }

    void registerWorldGenerators() {
    }

    void registerEntities() {
    }

    void registerVillagers() {
    }

    void registerOther() {
    }

    public ResourceLocation resourceLocation(String path) {
        return new ResourceLocation(this.assetKey, path);
    }

    public String soundName(String name) {
        return this.assetKey + ":" + name;
    }

    public ResourceLocation textureLocation(String path) {
        return this.resourceLocation("textures/" + path);
    }

    public Set<String> listResources(String subdir) {
        try {
            HashSet<String> result = new HashSet<String>();
            if (this.resourceURL != null) {
                String protocol = this.resourceURL.getProtocol();
                if (protocol.equals("jar")) {
                    String resPath = this.resourceURL.getPath();
                    int pling = resPath.lastIndexOf("!");
                    URL jarURL = new URL(resPath.substring(0, pling));
                    String resDirInJar = resPath.substring(pling + 2);
                    String prefix = resDirInJar + subdir + "/";
                    JarFile jar = new JarFile(new File(jarURL.toURI()));
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String name = entries.nextElement().getName();
                        if (!name.startsWith(prefix) || name.endsWith("/") || name.contains("/.")) continue;
                        result.add(name.substring(prefix.length()));
                    }
                } else {
                    throw new RuntimeException("Resource URL protocol " + protocol + " not supported");
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void registerContainers() {
    }

    public void addContainer(Enum id, Class<? extends Container> cls) {
        this.addContainer(id.ordinal(), cls);
    }

    public void addContainer(int id, Class<? extends Container> cls) {
        this.containerClasses.put(id, cls);
    }

    public void openGui(EntityPlayer player, Enum id, World world, int x, int y, int z) {
        this.openGui(player, id.ordinal(), world, x, y, z);
    }

    public void openGui(EntityPlayer player, int id, World world, int x, int y, int z) {
        if (this.debugGui) {
            System.out.printf("BaseMod.openGui: for %s with id %s in %s at (%s, %s, %s)\n", this, id, world, x, y, z);
        }
        player.openGui((Object)this, id, world, x, y, z);
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Class<? extends Container> cls;
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: for id %s\n", id);
        }
        Object result = (cls = this.containerClasses.get(id)) != null ? this.createGuiElement(cls, player, world, x, y, z) : this.getGuiContainer(id, player, world, x, y, z);
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: Returning %s\n", result);
        }
        return result;
    }

    Container getGuiContainer(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (this.debugGui) {
            System.out.printf("%s: BaseMod.getGuiContainer: No Container class found for gui id %d\n", this, id);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    Object createGuiElement(Class cls, EntityPlayer player, World world, int x, int y, int z) {
        try {
            try {
                if (this.debugGui) {
                    System.out.printf("BaseMod.createGuiElement: Invoking create method of %s for %s in %s\n", cls, player, world);
                }
                return cls.getMethod("create", EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, player, world, x, y, z);
            }
            catch (NoSuchMethodException e) {
                if (this.debugGui) {
                    System.out.printf("BaseMod.createGuiElement: Invoking constructor of %s\n", cls);
                }
                return cls.getConstructor(EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(player, world, x, y, z);
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            System.out.printf("BaseMod.createGuiElement: %s: %s\n", e, cause);
            if (cause != null) {
                cause.printStackTrace();
            } else {
                e.printStackTrace();
            }
            return null;
        }
    }

    static class VSBinding
    extends IDBinding<ResourceLocation> {
        VSBinding() {
        }
    }

    static class IDBinding<T> {
        public int id;
        public T object;

        IDBinding() {
        }
    }

    static interface ITileEntity {
        public void onAddedToWorld();
    }

    static interface IBlock {
        public void setRenderType(int var1);

        public String getQualifiedRendererClassName();
    }
}

