/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gcewing.lighting.BaseMod;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class BaseModClient
implements IGuiHandler {
    static Map<String, BRBinding> blockRenderers = new HashMap<String, BRBinding>();
    BaseMod base;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();

    public BaseModClient(BaseMod mod) {
        this.base = mod;
    }

    public void preInit(FMLPreInitializationEvent e) {
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.registerScreens();
        this.registerRenderers();
        this.registerSounds();
        this.registerOther();
        this.registerImplicitBlockRenderers();
        this.registerSavedVillagerSkins();
    }

    void registerImplicitBlockRenderers() {
        for (BaseMod.IBlock block : this.base.registeredBlocks) {
            BRBinding b;
            String name = block.getQualifiedRendererClassName();
            if (name == null || (b = this.getBlockRendererForName(name)) == null) continue;
            block.setRenderType(b.id);
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry reg = VillagerRegistry.instance();
        for (BaseMod.VSBinding b : this.base.registeredVillagers) {
            reg.registerVillagerSkin(b.id, (ResourceLocation)b.object);
        }
    }

    BRBinding getBlockRendererForName(String name) {
        BRBinding b = blockRenderers.get(name);
        if (b == null) {
            ISimpleBlockRenderingHandler h;
            Class<?> cls;
            try {
                cls = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Block renderer class %s not found", name));
            }
            try {
                h = (ISimpleBlockRenderingHandler)cls.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            b = new BRBinding();
            b.id = RenderingRegistry.getNextAvailableRenderId();
            b.object = h;
            RenderingRegistry.registerBlockHandler((int)b.id, (ISimpleBlockRenderingHandler)h);
            blockRenderers.put(name, b);
        }
        return b;
    }

    String qualifyName(String name) {
        return this.getClass().getPackage().getName() + "." + name;
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum id, Class<? extends GuiScreen> cls) {
        this.addScreen(id.ordinal(), cls);
    }

    public void addScreen(int id, Class<? extends GuiScreen> cls) {
        this.screenClasses.put(id, cls);
    }

    void registerRenderers() {
    }

    void addBlockRenderer(BaseMod.IBlock block, ISimpleBlockRenderingHandler renderer) {
        this.addBlockRenderer(renderer, block);
    }

    void addBlockRenderer(ISimpleBlockRenderingHandler renderer, BaseMod.IBlock ... blocks) {
        int renderID = RenderingRegistry.getNextAvailableRenderId();
        for (BaseMod.IBlock block : blocks) {
            System.out.printf("BaseModClient: Registering %s with id %s for %s\n", renderer, renderID, block);
            block.setRenderType(renderID);
            RenderingRegistry.registerBlockHandler((int)renderID, (ISimpleBlockRenderingHandler)renderer);
        }
    }

    void addItemRenderer(Item item, IItemRenderer renderer) {
        MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)renderer);
    }

    void addItemRenderer(Block block, IItemRenderer renderer) {
        MinecraftForgeClient.registerItemRenderer((Item)block.func_149650_a(0, null, 0), (IItemRenderer)renderer);
    }

    void addTileEntityRenderer(Class<? extends TileEntity> teClass, TileEntitySpecialRenderer renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(teClass, (TileEntitySpecialRenderer)renderer);
    }

    void addEntityRenderer(Class<? extends Entity> entityClass, Render renderer) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, (Render)renderer);
    }

    public static void openClientGui(GuiScreen gui) {
        FMLClientHandler.instance().getClient().func_147108_a(gui);
    }

    public void bindTexture(String path) {
        ResourceLocation rsrc = this.base.resourceLocation("textures/" + path);
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        tm.func_110577_a(rsrc);
    }

    void registerSounds() {
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return this.base.getServerGuiElement(id, player, world, x, y, z);
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Class<? extends GuiScreen> cls = this.screenClasses.get(id);
        if (cls != null) {
            return this.base.createGuiElement(cls, player, world, x, y, z);
        }
        return this.getGuiScreen(id, player, world, x, y, z);
    }

    GuiScreen getGuiScreen(int id, EntityPlayer player, World world, int x, int y, int z) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, id);
        return null;
    }

    static class BRBinding
    extends IDBinding<ISimpleBlockRenderingHandler> {
        BRBinding() {
        }
    }

    static class IDBinding<T> {
        public int id;
        public T object;

        IDBinding() {
        }
    }
}

