/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting.ic2;

import cpw.mods.fml.common.eventhandler.Event;
import gcewing.lighting.ic2.BlockFloodlightIC2;
import gcewing.lighting.ic2.GregsLightingIC2;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TEFloodlightIC2
extends TileEntity
implements IEnergySink {
    final double maxEnergy = 64.0;
    final int maxInput = 32;
    final double energyUsedPerTick = 1.0;
    double energy = 0.0;
    boolean addedToEnergyNet = false;

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energy = nbt.func_74769_h("energy");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("energy", this.energy);
    }

    @Override
    public int getMaxSafeInput() {
        return 32;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double demandedEnergyUnits() {
        double req = this.energy < 32.0 ? 64.0 - this.energy : 0.0;
        return req;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (amount > (double)this.getMaxSafeInput()) {
            GregsLightingIC2.explodeMachineAt(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return 0.0;
        }
        boolean hadEnergy = this.energy > 0.0;
        this.energy += amount;
        if (hadEnergy != this.energy > 0.0) {
            this.func_70296_d();
            this.updateBlock();
        }
        return 0.0;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
            }
            if (this.isActive()) {
                this.energy -= 1.0;
                if (this.energy < 0.0) {
                    this.energy = 0.0;
                }
                this.func_70296_d();
                if (!this.isActive()) {
                    this.updateBlock();
                }
            }
        }
    }

    public void func_145843_s() {
        this.removeFromEnergyNet();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.removeFromEnergyNet();
        super.onChunkUnload();
    }

    void removeFromEnergyNet() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    BlockFloodlightIC2 getBlock() {
        return (BlockFloodlightIC2)this.func_145838_q();
    }

    void updateBlock() {
        BlockFloodlightIC2 block = this.getBlock();
        block.update(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        block.updateBeam(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isActive() {
        boolean on = this.switchedOn();
        boolean redstone = this.receivingRedstoneSignal();
        return this.energy > 0.0 && (on || redstone);
    }

    public boolean switchedOn() {
        BlockFloodlightIC2 block = this.getBlock();
        boolean result = block.switchedOn;
        return result;
    }

    boolean receivingRedstoneSignal() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

