/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.registry.GameRegistry;
import gcewing.lighting.BaseMod;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseContainerBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    static Random random = new Random();
    public int renderID = 0;
    Class<? extends TileEntity> tileEntityClass = null;
    String[] iconNames = null;
    Icon[] icons;

    public BaseContainerBlock(int n, Material material) {
        this(n, material, null);
    }

    public BaseContainerBlock(int n, Material material, Class<TE> clazz) {
        super(n, material);
        this.tileEntityClass = clazz;
        if (clazz != null) {
            try {
                GameRegistry.registerTileEntity(clazz, (String)clazz.getName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static Icon getIcon(Block block, IconRegister iconRegister, String string) {
        String string2 = block.getClass().getPackage().getName().replace(".", "_");
        return iconRegister.func_94245_a(string2 + ":" + string);
    }

    public static Icon[] getIcons(Block block, IconRegister iconRegister, String ... stringArray) {
        Icon[] iconArray = new Icon[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            iconArray[i] = BaseContainerBlock.getIcon(block, iconRegister, stringArray[i]);
        }
        return iconArray;
    }

    void setIconNames(String ... stringArray) {
        this.iconNames = stringArray;
    }

    void setPrefixedIconNames(String string, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = string + "-" + stringArray[i];
        }
        this.setIconNames(stringArray2);
    }

    public int func_71857_b() {
        return this.renderID;
    }

    @Override
    public void setRenderType(int n) {
        this.renderID = n;
    }

    @Override
    public String getQualifiedRendererClassName() {
        String string = this.getRendererClassName();
        if (string != null) {
            string = this.getClass().getPackage().getName() + "." + string;
        }
        return string;
    }

    String getRendererClassName() {
        return null;
    }

    public boolean func_71886_c() {
        return this.renderID == 0;
    }

    public void func_94332_a(IconRegister iconRegister) {
        this.icons = this.iconNames != null ? this.getIcons(iconRegister, this.iconNames) : this.getIcons(iconRegister, this.func_71917_a().substring(5));
    }

    protected Icon getIcon(IconRegister iconRegister, String string) {
        return BaseContainerBlock.getIcon((Block)this, iconRegister, string);
    }

    protected Icon[] getIcons(IconRegister iconRegister, String ... stringArray) {
        return BaseContainerBlock.getIcons((Block)this, iconRegister, stringArray);
    }

    public Icon func_71858_a(int n, int n2) {
        return this.getLocalIcon(n, n2);
    }

    Icon getLocalIcon(int n, int n2) {
        if (this.icons != null) {
            if (n < this.icons.length) {
                return this.icons[n];
            }
            return this.icons[this.icons.length - 1];
        }
        return null;
    }

    public boolean hasTileEntity(int n) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        if (this.func_71887_s()) {
            return (TE)iBlockAccess.func_72796_p(n, n2, n3);
        }
        return null;
    }

    public TileEntity func_72274_a(World world) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public void func_71861_g(World world, int n, int n2, int n3) {
        super.func_71861_g(world, n, n2, n3);
        TE TE = this.getTileEntity((IBlockAccess)world, n, n2, n3);
        if (TE instanceof BaseMod.ITileEntity) {
            ((BaseMod.ITileEntity)TE).onAddedToWorld();
        }
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        IInventory iInventory;
        TileEntity tileEntity = world.func_72796_p(n, n2, n3);
        if (tileEntity instanceof IInventory && (iInventory = (IInventory)tileEntity) != null) {
            for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
                ItemStack itemStack = iInventory.func_70301_a(i);
                if (itemStack == null) continue;
                float f = random.nextFloat() * 0.8f + 0.1f;
                float f2 = random.nextFloat() * 0.8f + 0.1f;
                float f3 = random.nextFloat() * 0.8f + 0.1f;
                while (itemStack.field_77994_a > 0) {
                    int n6 = random.nextInt(21) + 10;
                    if (n6 > itemStack.field_77994_a) {
                        n6 = itemStack.field_77994_a;
                    }
                    itemStack.field_77994_a -= n6;
                    EntityItem entityItem = new EntityItem(world, (double)((float)n + f), (double)((float)n2 + f2), (double)((float)n3 + f3), new ItemStack(itemStack.field_77993_c, n6, itemStack.func_77960_j()));
                    float f4 = 0.05f;
                    entityItem.field_70159_w = (float)random.nextGaussian() * f4;
                    entityItem.field_70181_x = (float)random.nextGaussian() * f4 + 0.2f;
                    entityItem.field_70179_y = (float)random.nextGaussian() * f4;
                    if (itemStack.func_77942_o()) {
                        entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityItem);
                }
            }
        }
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }
}

