/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gcewing.lighting.BaseMod;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundPool;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.src.ModLoader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class BaseModClient
implements IGuiHandler {
    static Map<String, BRBinding> blockRenderers = new HashMap<String, BRBinding>();
    public Minecraft mc;
    BaseMod base;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();

    public BaseModClient(BaseMod baseMod) {
        this.base = baseMod;
        this.mc = ModLoader.getMinecraftInstance();
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        this.registerScreens();
        this.registerRenderers();
        this.registerSounds();
        this.registerOther();
        this.registerImplicitBlockRenderers();
        this.registerSavedVillagerSkins();
    }

    void registerImplicitBlockRenderers() {
        for (BaseMod.IBlock iBlock : this.base.registeredBlocks) {
            BRBinding bRBinding;
            String string = iBlock.getQualifiedRendererClassName();
            if (string == null || (bRBinding = this.getBlockRendererForName(string)) == null) continue;
            iBlock.setRenderType(bRBinding.id);
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry villagerRegistry = VillagerRegistry.instance();
        for (BaseMod.VSBinding vSBinding : this.base.registeredVillagers) {
            villagerRegistry.registerVillagerSkin(vSBinding.id, (ResourceLocation)vSBinding.object);
        }
    }

    BRBinding getBlockRendererForName(String string) {
        BRBinding bRBinding = blockRenderers.get(string);
        if (bRBinding == null) {
            ISimpleBlockRenderingHandler iSimpleBlockRenderingHandler;
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(String.format("Block renderer class %s not found", string));
            }
            try {
                iSimpleBlockRenderingHandler = (ISimpleBlockRenderingHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            bRBinding = new BRBinding();
            bRBinding.id = RenderingRegistry.getNextAvailableRenderId();
            bRBinding.object = iSimpleBlockRenderingHandler;
            RenderingRegistry.registerBlockHandler((int)bRBinding.id, (ISimpleBlockRenderingHandler)iSimpleBlockRenderingHandler);
            blockRenderers.put(string, bRBinding);
        }
        return bRBinding;
    }

    String qualifyName(String string) {
        return this.getClass().getPackage().getName() + "." + string;
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum enum_, Class<? extends GuiScreen> clazz) {
        this.addScreen(enum_.ordinal(), clazz);
    }

    public void addScreen(int n, Class<? extends GuiScreen> clazz) {
        this.screenClasses.put(n, clazz);
    }

    void registerRenderers() {
    }

    void addBlockRenderer(BaseMod.IBlock iBlock, ISimpleBlockRenderingHandler iSimpleBlockRenderingHandler) {
        this.addBlockRenderer(iSimpleBlockRenderingHandler, iBlock);
    }

    void addBlockRenderer(ISimpleBlockRenderingHandler iSimpleBlockRenderingHandler, BaseMod.IBlock ... iBlockArray) {
        int n = RenderingRegistry.getNextAvailableRenderId();
        for (BaseMod.IBlock iBlock : iBlockArray) {
            System.out.printf("BaseModClient: Registering %s with id %s for %s\n", iSimpleBlockRenderingHandler, n, iBlock);
            iBlock.setRenderType(n);
            RenderingRegistry.registerBlockHandler((int)n, (ISimpleBlockRenderingHandler)iSimpleBlockRenderingHandler);
        }
    }

    void addItemRenderer(Item item, IItemRenderer iItemRenderer) {
        MinecraftForgeClient.registerItemRenderer((int)item.field_77779_bT, (IItemRenderer)iItemRenderer);
    }

    void addItemRenderer(Block block, IItemRenderer iItemRenderer) {
        MinecraftForgeClient.registerItemRenderer((int)block.func_71885_a(0, null, 0), (IItemRenderer)iItemRenderer);
    }

    void addTileEntityRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)tileEntitySpecialRenderer);
    }

    void addEntityRenderer(Class<? extends Entity> clazz, Render render) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (Render)render);
    }

    public void bindTexture(String string) {
        ResourceLocation resourceLocation = this.base.resourceLocation("textures/" + string);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(resourceLocation);
    }

    void registerSounds() {
        try {
            if (this.debugSound) {
                System.out.printf("%s: BaseModClient.registerSounds\n", this.base.modPackage);
            }
            SoundPool soundPool = this.mc.field_71416_A.field_77379_b;
            Set<String> set = this.base.listResources("sound");
            for (String string : set) {
                String string2 = String.format("%s:%s", this.base.assetKey, string);
                if (this.debugSound) {
                    System.out.printf("%s: BaseModClient.registerSounds: %s\n", this.base.modPackage, string2);
                }
                soundPool.func_77459_a(string2);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return this.base.getServerGuiElement(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        Class<? extends GuiScreen> clazz = this.screenClasses.get(n);
        if (clazz != null) {
            return this.base.createGuiElement(clazz, entityPlayer, world, n2, n3, n4);
        }
        return this.getGuiScreen(n, entityPlayer, world, n2, n3, n4);
    }

    GuiScreen getGuiScreen(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, n);
        return null;
    }

    static class BRBinding
    extends IDBinding<ISimpleBlockRenderingHandler> {
        BRBinding() {
        }
    }

    static class IDBinding<T> {
        public int id;
        public T object;

        IDBinding() {
        }
    }
}

