/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting.ic2;

import gcewing.lighting.GregsLighting;
import gcewing.lighting.ic2.BlockFloodlightIC2;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TEFloodlightIC2
extends TileEntity
implements IEnergySink {
    final int maxEnergy = 64;
    final int maxInput = 32;
    final int energyUsedPerTick = 1;
    int energy = 0;
    boolean addedToEnergyNet = false;

    public void func_70307_a(NBTTagCompound nBTTagCompound) {
        super.func_70307_a(nBTTagCompound);
        this.energy = nBTTagCompound.func_74762_e("energy");
        this.addedToEnergyNet = nBTTagCompound.func_74767_n("addedToEnergyNet");
    }

    public void func_70310_b(NBTTagCompound nBTTagCompound) {
        super.func_70310_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("energy", this.energy);
        nBTTagCompound.func_74757_a("addedToEnergyNet", this.addedToEnergyNet);
    }

    @Override
    public int getMaxSafeInput() {
        return 32;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity tileEntity, Direction direction) {
        return true;
    }

    @Override
    public int demandsEnergy() {
        if (this.energy < 32) {
            return 64 - this.energy;
        }
        return 0;
    }

    @Override
    public int injectEnergy(Direction direction, int n) {
        if (n > 32) {
            System.out.printf("TEFloodlightIC2.injectEnergy: Exploding\n", new Object[0]);
            GregsLighting.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0;
        }
        boolean bl = this.energy > 0;
        int n2 = 0;
        this.energy += n;
        if (this.energy > 64) {
            n2 = this.energy - 64;
            this.energy = 64;
        }
        if (bl != this.energy > 0) {
            this.func_70296_d();
            this.updateBlock();
        }
        return n2;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            if (!this.addedToEnergyNet) {
                EnergyNet.getForWorld(this.field_70331_k).addTileEntity(this);
                this.addedToEnergyNet = true;
                this.func_70296_d();
            }
            if (this.isActive()) {
                --this.energy;
                if (this.energy < 0) {
                    this.energy = 0;
                }
                this.func_70296_d();
                if (!this.isActive()) {
                    this.updateBlock();
                }
            }
        }
    }

    public void func_70313_j() {
        if (this.addedToEnergyNet) {
            EnergyNet.getForWorld(this.field_70331_k).removeTileEntity(this);
            this.addedToEnergyNet = false;
            this.func_70296_d();
        }
        super.func_70313_j();
    }

    BlockFloodlightIC2 getBlock() {
        return (BlockFloodlightIC2)this.func_70311_o();
    }

    void updateBlock() {
        BlockFloodlightIC2 blockFloodlightIC2 = this.getBlock();
        blockFloodlightIC2.update(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        blockFloodlightIC2.updateBeam(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isActive() {
        boolean bl = this.switchedOn();
        boolean bl2 = this.receivingRedstoneSignal();
        return this.energy > 0 && (bl || bl2);
    }

    public boolean switchedOn() {
        BlockFloodlightIC2 blockFloodlightIC2 = this.getBlock();
        boolean bl = blockFloodlightIC2.switchedOn;
        return bl;
    }

    boolean receivingRedstoneSignal() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

