/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.BaseContainerBlock;
import gcewing.lighting.Floodlight;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockFloodlight<TE extends TileEntity>
extends BaseContainerBlock<TE> {
    static int renderType;
    protected Icon[] icons;

    public BlockFloodlight(int n) {
        this(n, Material.field_76246_e, null);
    }

    public BlockFloodlight(int n, Class<TE> clazz) {
        this(n, Material.field_76246_e, clazz);
    }

    public BlockFloodlight(int n, Material material, Class<TE> clazz) {
        super(n, material, clazz);
    }

    @Override
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[6];
        this.icons[0] = this.getIcon(iconRegister, "floodlight-bottom");
        this.icons[1] = this.getIcon(iconRegister, "floodlight-side");
        this.icons[2] = this.getIcon(iconRegister, "floodlight-top");
        this.icons[3] = this.getIcon(iconRegister, "floodlight-bottom-lit");
        this.icons[4] = this.getIcon(iconRegister, "floodlight-side-lit");
        this.icons[5] = this.getIcon(iconRegister, "floodlight-top-lit");
    }

    @Override
    public int func_71857_b() {
        return renderType;
    }

    @Override
    public void setRenderType(int n) {
        renderType = n;
    }

    public int func_85104_a(World world, int n, int n2, int n3, int n4, float f, float f2, float f3, int n5) {
        return n4 << 1;
    }

    @Override
    public Icon func_71858_a(int n, int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 += 3;
        }
        switch (n) {
            case 0: {
                return this.icons[n3];
            }
            case 1: {
                return this.icons[n3 + 2];
            }
        }
        return this.icons[n3 + 1];
    }

    public void func_71861_g(World world, int n, int n2, int n3) {
        this.update(world, n, n2, n3);
        this.updateBeam(world, n, n2, n3);
    }

    @Override
    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        ForgeDirection forgeDirection = this.direction(n5);
        Floodlight.propagateBeam(world, n, n2, n3, forgeDirection, 0, 1);
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    public void func_71863_a(World world, int n, int n2, int n3, int n4) {
        this.update(world, n, n2, n3);
        this.updateBeam(world, n, n2, n3);
    }

    public void update(World world, int n, int n2, int n3) {
        if (!world.field_72995_K) {
            boolean bl = this.isActive(world, n, n2, n3);
            this.setIlluminated(world, n, n2, n3, bl);
        }
    }

    public void updateBeam(World world, int n, int n2, int n3) {
        if (!world.field_72995_K) {
            ForgeDirection forgeDirection = this.getDirection(world, n, n2, n3);
            Floodlight.updateBeamInDirection(world, n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ, forgeDirection);
        }
    }

    public void setIlluminated(World world, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = world.func_72805_g(n, n2, n3);
        if (n5 != (n4 = n5 & 0xE | (bl ? 1 : 0))) {
            world.func_72921_c(n, n2, n3, n4, 3);
            world.func_72845_h(n, n2, n3);
        }
    }

    public boolean isActive(World world, int n, int n2, int n3) {
        return world.func_72864_z(n, n2, n3);
    }

    public boolean isActiveInDirection(World world, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return this.getDirection(world, n, n2, n3) == forgeDirection && this.isActive(world, n, n2, n3);
    }

    public ForgeDirection getDirection(World world, int n, int n2, int n3) {
        int n4 = world.func_72805_g(n, n2, n3);
        return this.direction(n4);
    }

    public ForgeDirection direction(int n) {
        return ForgeDirection.getOrientation((int)(n >> 1));
    }
}

