/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import gcewing.lighting.Trans3;
import gcewing.lighting.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public abstract class BaseBlockRenderer
implements ISimpleBlockRenderingHandler {
    public int renderID;
    Tessellator tess;
    IBlockAccess world;
    Block block;
    int blockX;
    int blockY;
    int blockZ;
    int metadata;
    double u0;
    double v0;
    double u1;
    double v1;
    double us;
    double vs;
    boolean textureOverridden;
    static double[][] cubeFaces = new double[][]{{-0.5, -0.5, 0.5, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0}, {-0.5, 0.5, -0.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.5, 0.5, -0.5, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0}, {-0.5, 0.5, 0.5, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {-0.5, 0.5, -0.5, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0}, {0.5, 0.5, 0.5, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}};

    public int getRenderId() {
        return this.renderID;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public void renderInventoryBlock(Block block, int n, int n2, RenderBlocks renderBlocks) {
        this.world = null;
        this.block = block;
        this.blockX = 0;
        this.blockY = 0;
        this.blockZ = 0;
        this.setUpTextureOverride(renderBlocks);
        this.metadata = n;
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.tess.func_78380_c(0xF000F0);
        Trans3 trans3 = new Trans3(0.0, 0.0, 0.0);
        this.tess.func_78382_b();
        this.renderBlock(trans3);
        this.tess.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int n, int n2, int n3, Block block, int n4, RenderBlocks renderBlocks) {
        this.world = iBlockAccess;
        this.block = block;
        this.blockX = n;
        this.blockY = n2;
        this.blockZ = n3;
        this.setUpTextureOverride(renderBlocks);
        this.metadata = iBlockAccess.func_72805_g(n, n2, n3);
        this.tess = Tessellator.field_78398_a;
        this.tess.func_78386_a(1.0f, 1.0f, 1.0f);
        Trans3 trans3 = new Trans3((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5);
        return this.renderBlock(trans3);
    }

    abstract boolean renderBlock(Trans3 var1);

    void setUpTextureOverride(RenderBlocks renderBlocks) {
        this.textureOverridden = false;
        Icon icon = renderBlocks.field_78664_d;
        if (icon != null) {
            this.useIcon(icon);
            this.textureOverridden = true;
        }
    }

    void selectTile(Icon icon) {
        this.selectTile(icon, 16, 16);
    }

    void selectTile(Icon icon, int n, int n2) {
        if (!this.textureOverridden) {
            this.useIcon(icon);
        }
        this.us = (this.u1 - this.u0) / (double)n;
        this.vs = (this.v1 - this.v0) / (double)n2;
    }

    void useIcon(Icon icon) {
        this.u0 = icon.func_94209_e();
        this.v0 = icon.func_94206_g();
        this.u1 = icon.func_94212_f();
        this.v1 = icon.func_94210_h();
    }

    void renderCube(Trans3 trans3) {
        for (int i = 0; i < 6; ++i) {
            this.selectTileForSide(i);
            this.setBrightnessForSide(trans3, i);
            this.cubeFace(trans3, cubeFaces[i]);
        }
    }

    void selectTileForSide(int n) {
        this.selectTile(this.block.func_71858_a(n, this.metadata));
    }

    void setBrightnessForSide(Trans3 trans3, int n) {
        if (this.world != null) {
            ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)n);
            Vector3 vector3 = trans3.p(forgeDirection.offsetX, forgeDirection.offsetY, forgeDirection.offsetZ);
            this.tess.func_78380_c(this.block.func_71874_e(this.world, vector3.floorX(), vector3.floorY(), vector3.floorZ()));
        } else {
            this.tess.func_78380_c(0xF000F0);
        }
    }

    void cubeFace(Trans3 trans3, double[] dArray) {
        this.tess.func_78375_b((float)dArray[9], (float)dArray[10], (float)dArray[11]);
        this.face(trans3, dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], 0.0, 0.0, 16.0, 16.0);
    }

    void face(Trans3 trans3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        this.vertex(trans3, d, d2, d3, d10, d11);
        this.vertex(trans3, d + d4, d2 + d5, d3 + d6, d10, d11 + d13);
        this.vertex(trans3, d + d4 + d7, d2 + d5 + d8, d3 + d6 + d9, d10 + d12, d11 + d13);
        this.vertex(trans3, d + d7, d2 + d8, d3 + d9, d10 + d12, d11);
    }

    void vertex(Trans3 trans3, double d, double d2, double d3, double d4, double d5) {
        Vector3 vector3 = trans3.p(d, d2, d3);
        this.tess.func_78374_a(vector3.x, vector3.y, vector3.z, this.u0 + d4 * this.us, this.v0 + d5 * this.vs);
    }
}

