/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gcewing.lighting.BaseConfiguration;
import gcewing.lighting.BaseModClient;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BaseMod
implements IGuiHandler {
    public BaseConfiguration config;
    public String modPackage;
    public String resourceDir;
    public String textureFile;
    public URL resourceURL;
    public BaseMod base;
    public IGuiHandler proxy;
    public boolean serverSide;
    public boolean clientSide;
    static File cfgFile;
    Map containerClasses = new HashMap();

    public String resourcePath(String string) {
        return this.resourceDir + string;
    }

    public BaseMod() {
        this.base = this;
        this.modPackage = this.getClass().getPackage().getName();
        String string = this.modPackage.replace(".", "/") + "/resources/";
        this.resourceDir = "/" + string;
        this.textureFile = this.resourceDir + "textures.png";
        this.resourceURL = this.getClass().getClassLoader().getResource(string);
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        this.serverSide = fMLPreInitializationEvent.getSide().isServer();
        this.clientSide = fMLPreInitializationEvent.getSide().isClient();
        cfgFile = fMLPreInitializationEvent.getSuggestedConfigurationFile();
        this.loadConfig();
        boolean[] blArray = (boolean[])ReflectionHelper.getPrivateValue(Configuration.class, (Object)((Object)this.config), (String[])new String[]{"configMarkers"});
        this.preallocateBlockIDs(blArray);
        this.preallocateItemIDs(blArray);
    }

    void preallocateBlockIDs(boolean[] blArray) {
        ConfigCategory configCategory = this.config.getCategory("block");
        for (Property property : configCategory.getValues().values()) {
            int n = property.getInt();
            if (n == -1) continue;
            blArray[n] = true;
        }
    }

    void preallocateItemIDs(boolean[] blArray) {
        ConfigCategory configCategory = this.config.getCategory("item");
        for (Property property : configCategory.getValues().values()) {
            int n = property.getInt();
            if (n == -1) continue;
            blArray[n + 256] = true;
        }
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        this.registerBlocks();
        this.registerItems();
        this.registerOres();
        this.registerRecipes();
        this.registerTileEntities();
        this.registerRandomItems();
        this.registerWorldGenerators();
        this.registerContainers();
        this.registerOther();
        this.proxy = fMLPostInitializationEvent.getSide().isClient() ? this.initClient() : this;
        if (this.proxy != null) {
            NetworkRegistry.instance().registerGuiHandler((Object)this, this.proxy);
        }
        this.saveConfig();
    }

    void loadConfig() {
        this.config = new BaseConfiguration(cfgFile);
    }

    void saveConfig() {
        if (this.config.extended) {
            this.config.save();
        }
    }

    String qualifiedName(String string) {
        return this.modPackage + "." + string;
    }

    BaseModClient initClient() {
        return new BaseModClient(this);
    }

    public Item newItem(String string, String string2) {
        return this.newItem(string, Item.class, string2);
    }

    public Item newItem(String string, Class clazz, String string2) {
        try {
            int n = this.config.getItem(string, 31743).getInt();
            Constructor constructor = clazz.getConstructor(Integer.TYPE);
            Item item = (Item)constructor.newInstance(n);
            item.func_77655_b(this.modPackage + ":" + string);
            LanguageRegistry.addName((Object)item, (String)string2);
            if (this.clientSide && item.func_77640_w() == null) {
                item.func_77637_a(CreativeTabs.field_78026_f);
            }
            return item;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Block newBlock(String string, String string2) {
        return this.newBlock(string, Block.class, string2);
    }

    public Block newBlock(String string, Class clazz, String string2) {
        return this.newBlock(string, clazz, ItemBlock.class, string2);
    }

    public Block newBlock(String string, Class clazz, Class clazz2, String string2) {
        try {
            int n = this.config.getBlock(string, 4095).getInt();
            Constructor constructor = clazz.getConstructor(Integer.TYPE);
            Block block = (Block)constructor.newInstance(n);
            block.func_71864_b(this.modPackage + ":" + string);
            GameRegistry.registerBlock((Block)block, (Class)clazz2);
            if (string2 != null) {
                LanguageRegistry.addName((Object)block, (String)string2);
                if (this.clientSide && block.func_71882_w() == null && !string2.startsWith("[")) {
                    block.func_71849_a(CreativeTabs.field_78026_f);
                }
            }
            return block;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void registerOre(String string, Block block) {
        OreDictionary.registerOre((String)string, (ItemStack)new ItemStack(block));
    }

    public void registerOre(String string, Item item) {
        OreDictionary.registerOre((String)string, (ItemStack)new ItemStack(item));
    }

    public void newRecipe(Item item, int n, Object ... objectArray) {
        this.newRecipe(new ItemStack(item, n), objectArray);
    }

    public void newRecipe(Block block, int n, Object ... objectArray) {
        this.newRecipe(new ItemStack(block, n), objectArray);
    }

    public void newRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, objectArray));
    }

    public void newShapelessRecipe(Block block, int n, Object ... objectArray) {
        this.newShapelessRecipe(new ItemStack(block, n), objectArray);
    }

    public void newShapelessRecipe(Item item, int n, Object ... objectArray) {
        this.newShapelessRecipe(new ItemStack(item, n), objectArray);
    }

    public void newShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemStack, objectArray));
    }

    public void newSmeltingRecipe(Item item, int n, Item item2) {
        GameRegistry.addSmelting((int)item2.field_77779_bT, (ItemStack)new ItemStack(item, n), (float)0.0f);
    }

    public void newSmeltingRecipe(Item item, int n, Block block) {
        GameRegistry.addSmelting((int)block.field_71990_ca, (ItemStack)new ItemStack(item, n), (float)0.0f);
    }

    public void addRandomChestItem(ItemStack itemStack, int n, int n2, int n3, String ... stringArray) {
        WeightedRandomChestContent weightedRandomChestContent = new WeightedRandomChestContent(itemStack, n, n2, n3);
        for (int i = 0; i < stringArray.length; ++i) {
            ChestGenHooks.addItem((String)stringArray[i], (WeightedRandomChestContent)weightedRandomChestContent);
        }
    }

    void registerBlocks() {
    }

    void registerItems() {
    }

    void registerOres() {
    }

    void registerRecipes() {
    }

    void registerTileEntities() {
    }

    void registerRandomItems() {
    }

    void registerWorldGenerators() {
    }

    void registerOther() {
    }

    public Set listResources(String string) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = this.resourceURL.getProtocol();
            if (string2.equals("jar")) {
                String string3 = this.resourceURL.getPath();
                int n = string3.indexOf("!");
                URL uRL = new URL(string3.substring(0, n));
                String string4 = string3.substring(n + 2);
                String string5 = string4 + string + "/";
                JarFile jarFile = new JarFile(new File(uRL.toURI()));
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string6 = enumeration.nextElement().getName();
                    if (!string6.startsWith(string5) || string6.endsWith("/") || string6.contains("/.")) continue;
                    hashSet.add(string6.substring(string5.length()));
                }
            } else {
                throw new RuntimeException("Resource URL protocol " + string2 + " not supported");
            }
            return hashSet;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    void registerContainers() {
    }

    public void addContainer(Enum enum_, Class clazz) {
        this.addContainer(enum_.ordinal(), clazz);
    }

    public void addContainer(int n, Class clazz) {
        this.containerClasses.put(n, clazz);
    }

    public void openGui(EntityPlayer entityPlayer, Enum enum_, World world, int n, int n2, int n3) {
        this.openGui(entityPlayer, enum_.ordinal(), world, n, n2, n3);
    }

    public void openGui(EntityPlayer entityPlayer, int n, World world, int n2, int n3, int n4) {
        entityPlayer.openGui((Object)this.base, n, world, n2, n3, n4);
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        Class clazz = (Class)this.containerClasses.get(n);
        if (clazz != null) {
            return this.createGuiElement(clazz, entityPlayer, world, n2, n3, n4);
        }
        return this.getGuiContainer(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return null;
    }

    Object createGuiElement(Class clazz, EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        try {
            try {
                return clazz.getMethod("create", EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, entityPlayer, world, n, n2, n3);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return clazz.getConstructor(EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(entityPlayer, world, n, n2, n3);
            }
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            System.out.printf("BaseMod.createGuiElement: %s: %s\n", exception, throwable);
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                exception.printStackTrace();
            }
            return null;
        }
    }

    Container getGuiContainer(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        System.out.printf("%s: BaseMod.getGuiContainer: No Container class found for gui id %d\n", this, n);
        return null;
    }
}

