/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.network.IGuiHandler;
import gcewing.lighting.BaseBlockRenderer;
import gcewing.lighting.BaseMod;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundPool;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.src.ModLoader;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class BaseModClient
implements IGuiHandler {
    public Minecraft mc;
    BaseMod base;
    Map screenClasses = new HashMap();

    public BaseModClient(BaseMod baseMod) {
        this.base = baseMod;
        this.mc = ModLoader.getMinecraftInstance();
        this.registerScreens();
        this.registerRenderers();
        this.registerSounds();
        this.registerOther();
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum enum_, Class clazz) {
        this.addScreen(enum_.ordinal(), clazz);
    }

    public void addScreen(int n, Class clazz) {
        this.screenClasses.put(n, clazz);
    }

    void registerRenderers() {
    }

    void addBlockRenderer(IRenderType iRenderType, BaseBlockRenderer baseBlockRenderer) {
        this.addBlockRenderer(baseBlockRenderer, iRenderType);
    }

    void addBlockRenderer(BaseBlockRenderer baseBlockRenderer, IRenderType ... iRenderTypeArray) {
        int n;
        baseBlockRenderer.renderID = n = RenderingRegistry.getNextAvailableRenderId();
        for (IRenderType iRenderType : iRenderTypeArray) {
            iRenderType.setRenderType(n);
            RenderingRegistry.registerBlockHandler((int)n, (ISimpleBlockRenderingHandler)baseBlockRenderer);
        }
    }

    void addItemRenderer(Item item, IItemRenderer iItemRenderer) {
        MinecraftForgeClient.registerItemRenderer((int)item.field_77779_bT, (IItemRenderer)iItemRenderer);
    }

    void addItemRenderer(Block block, IItemRenderer iItemRenderer) {
        MinecraftForgeClient.registerItemRenderer((int)block.func_71885_a(0, null, 0), (IItemRenderer)iItemRenderer);
    }

    void addTileEntityRenderer(Class clazz, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer((Class)clazz, (TileEntitySpecialRenderer)tileEntitySpecialRenderer);
    }

    void registerSounds() {
        try {
            SoundPool soundPool = this.mc.field_71416_A.field_77379_b;
            String string = this.base.modPackage.replace(".", "/") + "/";
            String string2 = "sounds";
            Set set = this.base.listResources(string2);
            for (String string3 : set) {
                String string4 = string + string3;
                URL uRL = new URL(this.base.resourceURL, string2 + "/" + string3);
                soundPool.addSound(string4, uRL);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return this.base.getServerGuiElement(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        Class clazz = (Class)this.screenClasses.get(n);
        if (clazz != null) {
            return this.base.createGuiElement(clazz, entityPlayer, world, n2, n3, n4);
        }
        return this.getGuiScreen(n, entityPlayer, world, n2, n3, n4);
    }

    GuiScreen getGuiScreen(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, n);
        return null;
    }

    static interface IRenderType {
        public void setRenderType(int var1);
    }
}

