/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.api.fml.event.config;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraftforge.fml.config.ModConfig;

public final class ModConfigEvents {
    public static Event<Loading> loading(String modId) {
        Objects.requireNonNull(modId, "mod id is null");
        return ModConfigEventsHolder.modSpecific(modId).loading();
    }

    public static Event<Reloading> reloading(String modId) {
        Objects.requireNonNull(modId, "mod id is null");
        return ModConfigEventsHolder.modSpecific(modId).reloading();
    }

    private ModConfigEvents() {
    }

    record ModConfigEventsHolder(String modId, Event<Loading> loading, Event<Reloading> reloading) {
        private static final Map<String, ModConfigEventsHolder> MOD_SPECIFIC_EVENT_HOLDERS = Maps.newConcurrentMap();

        static synchronized ModConfigEventsHolder modSpecific(String modId) {
            return MOD_SPECIFIC_EVENT_HOLDERS.computeIfAbsent(modId, ModConfigEventsHolder::create);
        }

        private static ModConfigEventsHolder create(String modId) {
            Event loading = EventFactory.createArrayBacked(Loading.class, listeners -> config -> {
                for (Loading event : listeners) {
                    event.onModConfigLoading(config);
                }
            });
            Event reloading = EventFactory.createArrayBacked(Reloading.class, listeners -> config -> {
                for (Reloading event : listeners) {
                    event.onModConfigReloading(config);
                }
            });
            return new ModConfigEventsHolder(modId, (Event<Loading>)loading, (Event<Reloading>)reloading);
        }
    }

    @FunctionalInterface
    public static interface Reloading {
        public void onModConfigReloading(ModConfig var1);
    }

    @FunctionalInterface
    public static interface Loading {
        public void onModConfigLoading(ModConfig var1);
    }
}

