/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.client.config;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.network.client.NetworkHooks;
import net.minecraftforge.network.config.ConfigSync;
import org.slf4j.Logger;

public class ConfigSyncClient {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ConfigSyncClient INSTANCE = new ConfigSyncClient(ConfigTracker.INSTANCE);
    private final ConfigTracker tracker;

    private ConfigSyncClient(ConfigTracker tracker) {
        this.tracker = tracker;
    }

    public void clientInit() {
        ClientLoginNetworking.registerGlobalReceiver((class_2960)ConfigSync.SYNC_CONFIGS_CHANNEL, (client, handler, buf, listenerAdder) -> {
            String fileName = this.receiveSyncedConfig(buf);
            LOGGER.debug(ConfigSync.FMLHSMARKER_SLF4J, "Received config sync for {} from server", (Object)fileName);
            class_2540 response = PacketByteBufs.create();
            response.method_10814(fileName);
            LOGGER.debug(ConfigSync.FMLHSMARKER_SLF4J, "Sent config sync for {} to server", (Object)fileName);
            return CompletableFuture.completedFuture(response);
        });
        ClientLoginNetworking.registerGlobalReceiver((class_2960)ConfigSync.MODDED_CONNECTION_CHANNEL, (client, handler, buf, listenerAdder) -> {
            LOGGER.debug(ConfigSync.FMLHSMARKER_SLF4J, "Received modded connection marker from server");
            NetworkHooks.setModdedConnection();
            return CompletableFuture.completedFuture(PacketByteBufs.create());
        });
    }

    private String receiveSyncedConfig(class_2540 buf) {
        String fileName = buf.method_10800(Short.MAX_VALUE);
        byte[] fileData = buf.method_10795();
        if (!class_310.method_1551().method_1542()) {
            Optional.ofNullable(this.tracker.fileMap().get(fileName)).ifPresent(config -> config.acceptSyncedConfig(fileData));
        }
        return fileName;
    }
}

