/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ReadProfileMsg;
import com.li64.tide.registries.TideSoundEvents;
import com.li64.tide.util.TideUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class FishingJournalScreen
extends class_437 {
    private static final int SLOT_SIZE = 22;
    private static final int SLOT_MARGIN = 4;
    private static final class_2960 PROFILE_BG = Tide.resource("textures/gui/journal/journal_profile.png");
    private int numRows;
    private int numCols;
    private int totalSlots;
    private ArrayList<JournalPage> pages;
    public class_1799 profileFish = null;
    public JournalLayout.Profile profileConfig = null;
    public int page;
    public class_1657 player;

    public FishingJournalScreen(class_1657 player) {
        super(class_333.field_18967);
        this.player = player;
        this.loadJournalPages();
        this.method_25426();
        player.method_5783(TideSoundEvents.JOURNAL_OPEN, 0.9f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    private void loadJournalPages() {
        try {
            this.pages = new ArrayList();
            Tide.JOURNAL.getPageConfigs().stream().map(JournalPage::new).forEach(page -> this.pages.add((JournalPage)page));
        }
        catch (Exception e) {
            Tide.LOG.error("Exception in loading journal pages: {}, {}", (Object)e.getMessage(), (Object)e.getCause());
        }
        this.pages.removeIf(journalPage -> !TidePlayerData.CLIENT_DATA.hasPageUnlocked((JournalPage)journalPage));
        if (this.pages.size() > 1) {
            this.pages.remove(0);
        }
    }

    private void nextPage(int page) {
        this.method_37067();
        this.page = page;
        this.method_25426();
        this.player.method_5783(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    protected void method_25426() {
        this.totalSlots = this.getPage().getAllProfiles().size();
        this.numCols = this.calculateNumCols(this.totalSlots);
        this.numRows = this.calculateNumRows(this.totalSlots);
        this.method_37067();
        if (this.profileFish != null) {
            this.createProfileControls();
        } else {
            this.createMenuControls();
            this.createFishIcons();
        }
    }

    public void method_25419() {
        super.method_25419();
        this.player.method_5783(TideSoundEvents.JOURNAL_CLOSE, 0.9f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    private void createFishIcons() {
        int startX = (this.field_22789 - this.getTotalWidth()) / 2;
        int startY = (this.field_22790 - this.getTotalHeight()) / 2;
        List<JournalLayout.Profile> profiles = this.getPage().getAllProfiles();
        for (int i = 0; i < this.totalSlots && i < profiles.size(); ++i) {
            int row = i / this.numCols;
            int col = i % this.numCols;
            int x = startX + col * 26;
            int y = startY + row * 26 - 26;
            JournalLayout.Profile profile = profiles.get(i);
            if (profile.getFish().method_7960()) continue;
            this.method_37063((class_364)new FishButton(x, y, 22, 22, profile, this));
        }
    }

    private JournalPage getPage() {
        return this.pages.get(this.page);
    }

    private int calculateNumRows(int slots) {
        return class_3532.method_15386((float)((float)slots / (float)this.numCols));
    }

    private int calculateNumCols(int slots) {
        return Math.min(12, slots);
    }

    private int getTotalWidth() {
        return this.numCols * 26 - 4;
    }

    private int getTotalHeight() {
        return this.numRows * 26 - 4;
    }

    private void createMenuControls() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 80, this.field_22790 - 40, 160, 18).method_46431());
        class_4185 rightButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<<"), button -> this.pageLeft()).method_46434(this.field_22789 / 2 - 110, this.field_22790 - 40, 26, 18).method_46431();
        rightButton.field_22763 = this.page > 0;
        this.method_37063((class_364)rightButton);
        class_4185 leftButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)">>"), button -> this.pageRight()).method_46434(this.field_22789 / 2 + 84, this.field_22790 - 40, 26, 18).method_46431();
        leftButton.field_22763 = this.page < this.pages.size() - 1;
        this.method_37063((class_364)leftButton);
    }

    private void createProfileControls() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.closeProfile()).method_46434(this.field_22789 / 2 - 80, this.field_22790 - 40, 160, 18).method_46431());
    }

    private void closeProfile() {
        this.profileConfig = null;
        this.profileFish = null;
        this.method_25426();
        this.player.method_5783(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    public void pageLeft() {
        if (this.page > 0) {
            this.nextPage(this.page - 1);
        }
    }

    public void pageRight() {
        if (this.page < this.pages.size() - 1) {
            this.nextPage(this.page + 1);
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.profileFish == null) {
            class_5250 title = class_2561.method_43471((String)this.getPage().title());
            class_5250 content = class_2561.method_43471((String)this.getPage().content());
            List formattedContent = this.field_22793.method_1728((class_5348)content, 300);
            int titleX = (this.field_22789 - this.field_22793.method_27525((class_5348)title)) / 2;
            int titleY = 30;
            if (this.page == 0) {
                titleY = 70;
            }
            int contentX = (this.field_22789 - 300) / 2;
            int contentY = this.field_22790 - 90;
            if (this.page == 0) {
                contentY = this.field_22790 - 125;
            }
            graphics.method_25303(this.field_22793, title.getString(), titleX, titleY, 0xFFFFFF);
            for (int i = 0; i < formattedContent.size(); ++i) {
                graphics.method_35720(this.field_22793, (class_5481)formattedContent.get(i), contentX, contentY + 10 * i, 0xFFFFFF);
            }
        } else {
            this.renderProfile(graphics);
        }
    }

    public void openProfile(JournalLayout.Profile profile) {
        this.profileConfig = profile;
        this.profileFish = ((class_1792)class_7923.field_41178.method_10223(new class_2960(profile.fishItem()))).method_7854();
        this.player.method_5783(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
        Tide.NETWORK.sendToServer(new ReadProfileMsg(this.profileFish));
        this.method_25426();
    }

    public void renderProfile(class_332 graphics) {
        class_5481 charSequence;
        int i;
        int bgWidth = 291;
        int bgHeight = 202;
        int offsetY = 20;
        graphics.method_25290(PROFILE_BG, (this.field_22789 - bgWidth) / 2, (this.field_22790 - bgHeight) / 2 - offsetY, 0.0f, 0.0f, bgWidth, bgHeight, bgWidth, bgHeight);
        class_2583 underlined = class_2561.method_43473().method_10866().method_30938(Boolean.valueOf(true));
        class_5250 descriptionRaw = class_2561.method_43471((String)this.profileConfig.description());
        class_5250 locationTitleRaw = class_2561.method_43471((String)"profile.info.location").method_27696(underlined);
        class_5250 locationRaw = class_2561.method_43471((String)("profile.info.location." + this.profileConfig.location()));
        class_5250 climateTitleRaw = class_2561.method_43471((String)"profile.info.climate").method_27696(underlined);
        class_5250 climateRaw = class_2561.method_43471((String)("profile.info.climate." + this.profileConfig.climate()));
        List description = this.field_22793.method_1728((class_5348)descriptionRaw, 114);
        boolean isDescriptionEmpty = descriptionRaw.getString().isEmpty() || descriptionRaw.getString().contains("profile.item.");
        ArrayList location = new ArrayList();
        location.addAll(this.field_22793.method_1728((class_5348)locationTitleRaw, 114));
        location.addAll(this.field_22793.method_1728((class_5348)locationRaw, 114));
        ArrayList climate = new ArrayList();
        climate.addAll(this.field_22793.method_1728((class_5348)climateTitleRaw, 114));
        climate.addAll(this.field_22793.method_1728((class_5348)climateRaw, 114));
        class_2561 fishName = TideUtils.removeRawTextInName(this.profileFish.method_7964());
        float scaleAmount = 2.0f;
        int titleX = (this.field_22789 - this.field_22793.method_27525((class_5348)fishName) - bgWidth / 2) / 2;
        int imageX = (int)(((float)this.field_22789 - 16.0f * scaleAmount - (float)(bgWidth / 2)) / 2.0f);
        int leftContentX = (this.field_22789 - bgWidth / 2) / 2;
        int rightContentX = (this.field_22789 + bgWidth / 2) / 2;
        int rightTop = (this.field_22790 - 204) / 2 - 6;
        int leftTop = rightTop + (isDescriptionEmpty ? 55 : 0);
        graphics.method_51439(this.field_22793, fishName, titleX, leftTop, 0, false);
        if (!isDescriptionEmpty) {
            for (i = 0; i < description.size(); ++i) {
                graphics.method_51430(this.field_22793, (class_5481)description.get(i), leftContentX - 56, leftTop + 46 + 11 * i, 0, false);
            }
        }
        for (i = 0; i < location.size(); ++i) {
            charSequence = (class_5481)location.get(i);
            graphics.method_51430(this.field_22793, charSequence, rightContentX - this.field_22793.method_30880(charSequence) / 2, rightTop + 46 + 11 * i, 0, false);
        }
        for (i = 0; i < climate.size(); ++i) {
            charSequence = (class_5481)climate.get(i);
            graphics.method_51430(this.field_22793, charSequence, rightContentX - this.field_22793.method_30880(charSequence) / 2, rightTop + 86 + 11 * i, 0, false);
        }
        graphics.method_51448().method_22905(scaleAmount, scaleAmount, scaleAmount);
        graphics.method_51427(this.profileFish, (int)((float)imageX / scaleAmount), (int)((float)(leftTop + 11) / scaleAmount));
        graphics.method_51448().method_22905(1.0f / scaleAmount, 1.0f / scaleAmount, 1.0f / scaleAmount);
    }

    public static class FishButton
    extends class_4264 {
        private static final class_2960 slotTex = Tide.resource("textures/gui/journal/fish_border.png");
        private static final class_2960 slotHoverTex = Tide.resource("textures/gui/journal/fish_border_select.png");
        private static final class_2960 unreadTex = Tide.resource("textures/gui/journal/unread_icon.png");
        private static final class_2960 unreadHoverTex = Tide.resource("textures/gui/journal/unread_icon_select.png");
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final JournalLayout.Profile profile;
        private final FishingJournalScreen parent;

        public FishButton(int x, int y, int w, int h, JournalLayout.Profile profile, FishingJournalScreen parent) {
            super(x, y, w, h, class_333.field_18967);
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.profile = profile;
            this.parent = parent;
        }

        public void method_25306() {
            if (TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.profile.getFish())) {
                this.parent.openProfile(this.profile);
            }
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            class_2960 unreadTexture;
            class_2960 texture = this.method_25405(mouseX, mouseY) ? slotHoverTex : slotTex;
            graphics.method_25290(texture, this.x, this.y, 0.0f, 0.0f, this.w, this.h, this.w, this.h);
            if (!this.profile.getFish().method_7960()) {
                if (!TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.profile.getFish())) {
                    graphics.method_51422(0.0f, 0.0f, 0.0f, 1.0f);
                }
                graphics.method_51427(this.profile.getFish(), this.x + 3, this.y + 3);
                graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (!Tide.CONFIG.general.showUnread) {
                return;
            }
            class_2960 class_29602 = unreadTexture = this.method_25405(mouseX, mouseY) ? unreadHoverTex : unreadTex;
            if (TidePlayerData.CLIENT_DATA.isUnread(this.profile)) {
                graphics.method_25290(unreadTexture, this.x - 1, this.y - 1, 0.0f, 0.0f, 7, 7, 7, 7);
            }
        }

        protected void method_47399(@NotNull class_6382 output) {
        }
    }
}

