/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5632;
import org.jetbrains.annotations.Nullable;

public class BaitContents
implements class_5632 {
    public static final int MAX_STACKS = 3;
    private final List<class_1799> items;

    public BaitContents() {
        this(List.of());
    }

    public BaitContents(List<class_1799> items) {
        this.items = items;
    }

    public List<class_1799> items() {
        return this.items;
    }

    public class_1799 get(int index) {
        return this.items().get(index);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public String toString() {
        return "BaitContents" + this.items;
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10569("size", this.size());
        for (int i = 0; i < this.size(); ++i) {
            tag.method_10566("item-" + i, (class_2520)this.items.get(i).method_7953(new class_2487()));
        }
        return tag;
    }

    public static BaitContents fromNbt(class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return new BaitContents();
        }
        ImmutableList.Builder itemsBuilder = ImmutableList.builder();
        int size = tag.method_10550("size");
        for (int i = 0; i < size; ++i) {
            itemsBuilder.add((Object)class_1799.method_7915((class_2487)tag.method_10562("item-" + i)));
        }
        return new BaitContents((List<class_1799>)itemsBuilder.build());
    }

    public static class Mutable {
        private final List<class_1799> items;

        public Mutable(BaitContents contents) {
            this.items = contents == null ? new ArrayList<class_1799>() : new ArrayList<class_1799>(contents.items);
        }

        private int findStackIndex(class_1799 stack) {
            for (int i = 0; i < this.items.size(); ++i) {
                if (!class_1799.method_31577((class_1799)this.items.get(i), (class_1799)stack)) continue;
                return i;
            }
            return -1;
        }

        public void tryInsert(class_1799 stack) {
            if (!stack.method_7960() && stack.method_7909().method_31568()) {
                int index = this.findStackIndex(stack);
                int count = stack.method_7947();
                if (index != -1 && stack.method_7946()) {
                    class_1799 current = this.items.get(index);
                    int stackSize = stack.method_7914();
                    int amountToAdd = Math.min(stackSize - current.method_7947(), stack.method_7947());
                    class_1799 added = current.method_46651(current.method_7947() + amountToAdd);
                    stack.method_7934(amountToAdd);
                    this.items.set(index, added);
                } else if (this.items.size() < 3) {
                    this.items.add(stack.method_7971(count));
                }
            }
        }

        public void tryTransfer(class_1735 slot, class_1657 pPlayer) {
            class_1799 slotStack = slot.method_32753(slot.method_7677().method_7947(), slot.method_7675(), pPlayer);
            this.tryInsert(slotStack);
            if (!slotStack.method_7960()) {
                slot.method_32756(slotStack);
            }
        }

        @Nullable
        public class_1799 removeStack() {
            if (this.items.isEmpty()) {
                return null;
            }
            return this.items.remove(0).method_7972();
        }

        public void shrinkStack(class_1799 stack) {
            int index = this.findStackIndex(stack);
            if (index == -1) {
                return;
            }
            this.items.get(index).method_7934(1);
            if (this.items.get(index).method_7960()) {
                this.items.remove(index);
            }
        }

        public BaitContents toImmutable() {
            return new BaitContents(List.copyOf(this.items));
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }
    }
}

