/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.li64.tide.data.rods.BaitContents;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.jetbrains.annotations.NotNull;

public class ClientFishingRodTooltip
implements class_5684 {
    public static final class_2960 TEXTURE_LOCATION = new class_2960("textures/gui/container/bundle.png");
    private static final class_2561 MESSAGE = class_2561.method_43471((String)"text.tide.rod_tooltip.bait_desc");
    private static final int OFFSET_Y = 10;
    private static final int MARGIN_Y = 4;
    private static final int BG_BORDER = 1;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 20;
    private final BaitContents contents;

    public ClientFishingRodTooltip(BaitContents pContents) {
        this.contents = pContents;
    }

    public int method_32661() {
        return this.backgroundHeight() + 4 + 10;
    }

    public int method_32664(@NotNull class_327 font) {
        return Math.max(this.backgroundWidth(), font.method_27525((class_5348)MESSAGE));
    }

    private int backgroundWidth() {
        return this.gridWidth() * 18 + 2;
    }

    private int backgroundHeight() {
        return 22;
    }

    public void method_32666(@NotNull class_327 font, int x, int y, class_332 graphics) {
        int gridWidth = this.gridWidth();
        graphics.method_27535(font, MESSAGE, x, y, class_1767.field_7967.method_16357());
        for (int i = 0; i < gridWidth; ++i) {
            int dspX = x + i * 18 + 1;
            int dspY = y + 1 + 10;
            this.renderSlot(dspX, dspY, i, graphics, font);
        }
        this.drawBorder(x, y + 10, gridWidth, 1, graphics);
    }

    private void renderSlot(int x, int y, int index, class_332 graphics, class_327 font) {
        if (index >= this.contents.size()) {
            this.blit(graphics, x, y, Texture.SLOT);
        } else {
            class_1799 stack = this.contents.items().get(index);
            this.blit(graphics, x, y, Texture.SLOT);
            graphics.method_51428(stack, x + 1, y + 1, index);
            graphics.method_51431(font, stack, x + 1, y + 1);
            if (index == 0) {
                class_465.method_33285((class_332)graphics, (int)(x + 1), (int)(y + 1), (int)0);
            }
        }
    }

    private void drawBorder(int x, int y, int gw, int gh, class_332 guiGraphics) {
        int m;
        this.blit(guiGraphics, x, y, Texture.BORDER_CORNER_TOP);
        this.blit(guiGraphics, x + gw * 18 + 1, y, Texture.BORDER_CORNER_TOP);
        for (m = 0; m < gw; ++m) {
            this.blit(guiGraphics, x + 1 + m * 18, y, Texture.BORDER_HORIZONTAL_TOP);
            this.blit(guiGraphics, x + 1 + m * 18, y + gh * 20, Texture.BORDER_HORIZONTAL_BOTTOM);
        }
        for (m = 0; m < gh; ++m) {
            this.blit(guiGraphics, x, y + m * 20 + 1, Texture.BORDER_VERTICAL);
            this.blit(guiGraphics, x + gw * 18 + 1, y + m * 20 + 1, Texture.BORDER_VERTICAL);
        }
        this.blit(guiGraphics, x, y + gh * 20, Texture.BORDER_CORNER_BOTTOM);
        this.blit(guiGraphics, x + gw * 18 + 1, y + gh * 20, Texture.BORDER_CORNER_BOTTOM);
    }

    private void blit(class_332 guiGraphics, int x, int y, Texture texture) {
        guiGraphics.method_25291(TEXTURE_LOCATION, x, y, 0, (float)texture.x, (float)texture.y, texture.w, texture.h, 128, 128);
    }

    private int gridWidth() {
        return Math.max(3, (int)Math.ceil(Math.sqrt((double)this.contents.size() + 1.0)));
    }

    static enum Texture {
        SLOT(0, 0, 18, 20),
        BLOCKED_SLOT(0, 40, 18, 20),
        BORDER_VERTICAL(0, 18, 1, 20),
        BORDER_HORIZONTAL_TOP(0, 20, 18, 1),
        BORDER_HORIZONTAL_BOTTOM(0, 60, 18, 1),
        BORDER_CORNER_TOP(0, 20, 1, 1),
        BORDER_CORNER_BOTTOM(0, 60, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int j, int k, int l, int m) {
            this.x = j;
            this.y = k;
            this.w = l;
            this.h = m;
        }
    }
}

