/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.rods;

import com.li64.tide.data.rods.ModifierType;
import com.li64.tide.registries.TideItems;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class CustomRodManager {
    private static final class_1799 DEFAULT_BOBBER = TideItems.RED_FISHING_BOBBER.method_7854();
    private static final class_1799 DEFAULT_HOOK = TideItems.FISHING_HOOK.method_7854();
    private static final class_1799 DEFAULT_LINE = TideItems.FISHING_LINE.method_7854();

    private static void createModifierTag(class_1799 stack) {
        class_2487 modifierTag = new class_2487();
        modifierTag.method_10566("bobber", (class_2520)new class_2487());
        modifierTag.method_10566("hook", (class_2520)new class_2487());
        modifierTag.method_10566("line", (class_2520)new class_2487());
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        stack.method_7948().method_10566("modifier", (class_2520)modifierTag);
    }

    private static void updateModifiers(class_1799 stack) {
        if (!CustomRodManager.hasModifierTag(stack)) {
            CustomRodManager.createModifierTag(stack);
        }
    }

    public static void setBobber(class_1799 stack, class_1799 bobber) {
        CustomRodManager.setModifier(stack, ModifierType.BOBBER, bobber);
    }

    public static void setHook(class_1799 stack, class_1799 hook) {
        CustomRodManager.setModifier(stack, ModifierType.HOOK, hook);
    }

    public static void setLine(class_1799 stack, class_1799 line) {
        CustomRodManager.setModifier(stack, ModifierType.LINE, line);
    }

    public static void setModifier(class_1799 stack, ModifierType modifier, class_1799 accessory) {
        CustomRodManager.updateModifiers(stack);
        if (accessory == null) {
            CustomRodManager.getModifierTag(stack).method_10566(modifier.getID(), (class_2520)new class_2487());
            return;
        }
        class_2487 tag = accessory.method_7953(new class_2487());
        CustomRodManager.getModifierTag(stack).method_10566(modifier.getID(), (class_2520)tag);
    }

    public static boolean hasModifierTag(class_1799 stack) {
        return stack.method_7985() && stack.method_7948().method_10545("modifier");
    }

    public static class_2487 getModifierTag(class_1799 stack) {
        CustomRodManager.updateModifiers(stack);
        return (class_2487)stack.method_7948().method_10580("modifier");
    }

    public static class_1799 getBobber(class_1799 rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.BOBBER, DEFAULT_BOBBER);
    }

    public static class_1799 getHook(class_1799 rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.HOOK, DEFAULT_HOOK);
    }

    public static class_1799 getLine(class_1799 rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.LINE, DEFAULT_LINE);
    }

    public static boolean hasBobber(class_1799 rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.BOBBER) != null;
    }

    public static boolean hasHook(class_1799 rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.HOOK) != null;
    }

    public static boolean hasLine(class_1799 rod) {
        return CustomRodManager.getAccessory(rod, ModifierType.LINE) != null;
    }

    private static class_1799 getAccessory(class_1799 rod, ModifierType type) {
        return CustomRodManager.getAccessory(rod, type, null);
    }

    private static class_1799 getAccessory(class_1799 rod, ModifierType type, class_1799 defaultInstance) {
        CustomRodManager.updateModifiers(rod);
        class_2487 accessoryTag = CustomRodManager.getModifierTag(rod).method_10562(type.getID());
        if (accessoryTag.method_33133()) {
            return defaultInstance;
        }
        class_1799 accessory = class_1799.method_7915((class_2487)accessoryTag);
        return accessory.method_7960() ? defaultInstance : accessory;
    }
}

