/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.util;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.TideCriteriaTriggers;
import com.li64.tide.data.TideLootTables;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.loot.DepthLayer;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ShowToastMsg;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_39;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class TideUtils {
    public static HashMap<String, class_1792> PROFILE_ITEMS;

    public static boolean moddedDimension(class_5321<class_1937> dimension) {
        return dimension != class_1937.field_25179 && dimension != class_1937.field_25180 && dimension != class_1937.field_25181;
    }

    public static boolean shouldGrabTideLootTable(class_1799 item, class_3610 fluid) {
        if (item.method_31573(TideTags.Items.CRATES)) {
            return false;
        }
        if (item.method_31573(TideTags.Items.VANILLA_FISH) || new Random().nextInt(0, 4) == 0) {
            return true;
        }
        return fluid.method_15767(TideTags.Fluids.LAVA_FISHING);
    }

    public static class_2960 getTideLootTable(double x, double y, double z, class_3610 fluid, class_1937 level) {
        DepthLayer layer = DepthLayer.getLayerAt(y);
        class_6880 biomeHolder = level.method_23753(new class_2338((int)x, (int)y, (int)z));
        if (TideUtils.moddedDimension((class_5321<class_1937>)level.method_27983())) {
            if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_SURFACE;
            }
            return class_39.field_353;
        }
        if (level.method_27983() == class_1937.field_25180) {
            if (Tide.PLATFORM.isModLoaded("netherdepthsupgrade")) {
                Random random = new Random();
                if (random.nextFloat() > 0.65f) {
                    return new class_2960("netherdepthsupgrade", "gameplay/nether_fishing");
                }
            }
            return TideLootTables.Fishing.NETHER;
        }
        if (level.method_27983() == class_1937.field_25181) {
            if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.END_LAVA;
            }
            return TideLootTables.Fishing.END_WATER;
        }
        if (layer == DepthLayer.UNDERGROUND && level.method_27983() == class_1937.field_25179) {
            if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_UNDERGROUND;
            }
            return TideLootTables.Fishing.UNDERGROUND;
        }
        if (layer == DepthLayer.DEPTHS && level.method_27983() == class_1937.field_25179) {
            if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
                return TideLootTables.Fishing.LAVA_DEPTHS;
            }
            return TideLootTables.Fishing.DEPTHS;
        }
        if (fluid.method_15767(TideTags.Fluids.LAVA_FISHING)) {
            return TideLootTables.Fishing.LAVA_SURFACE;
        }
        if (biomeHolder.method_40220(TideTags.Climate.IS_COLD)) {
            if (biomeHolder.method_40220(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Fishing.SALTWATER_COLD;
            }
            return TideLootTables.Fishing.FRESHWATER_COLD;
        }
        if (biomeHolder.method_40220(TideTags.Climate.IS_WARM)) {
            if (biomeHolder.method_40220(TideTags.Climate.IS_SALTWATER)) {
                return TideLootTables.Fishing.SALTWATER_WARM;
            }
            return TideLootTables.Fishing.FRESHWATER_WARM;
        }
        if (biomeHolder.method_40220(TideTags.Climate.IS_SALTWATER)) {
            return TideLootTables.Fishing.SALTWATER_NORMAL;
        }
        return TideLootTables.Fishing.FRESHWATER_NORMAL;
    }

    public static boolean isJournalFish(class_1799 stack) {
        if (PROFILE_ITEMS == null || PROFILE_ITEMS.size() != Tide.JOURNAL.getProfileConfigs().size()) {
            PROFILE_ITEMS = new HashMap();
            Tide.JOURNAL.getProfileConfigs().forEach(config -> PROFILE_ITEMS.put(config.fishItem(), TideUtils.getItemFromName(config.fishItem())));
        }
        return PROFILE_ITEMS.containsKey(TideUtils.getNameFromItem(stack.method_7909()));
    }

    public static String getNameFromItem(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item).toString();
    }

    public static class_1792 getItemFromName(String name) {
        return (class_1792)class_7923.field_41178.method_10223(new class_2960(name));
    }

    public static void checkPageCompletion(TidePlayerData data, JournalPage page, class_3222 player) {
        if (TideUtils.isCategoryCompleted(data, page) && !data.hasPageCompleted(page)) {
            data.pagesCompleted.add(page.id());
            if (data.pagesCompleted.size() <= 1) {
                TideCriteriaTriggers.FINISH_PAGE.trigger(player);
            }
            if (data.pagesCompleted.size() >= Tide.JOURNAL.getPageConfigs().size() - 1) {
                data.finishedJournal = true;
                TideCriteriaTriggers.FINISH_JOURNAL.trigger(player);
            }
            data.syncTo(player);
            Tide.LOG.debug("Player completed category: {}", (Object)page.idName());
            Tide.LOG.debug("Completed {}/{} categories", (Object)data.pagesCompleted.size(), (Object)Tide.JOURNAL.getPageConfigs().size());
        }
    }

    public static boolean isCategoryCompleted(TidePlayerData data, JournalPage page) {
        List<class_1792> fishes = TideUtils.getFishFromProfileList(page.getAllProfiles());
        if (fishes == null) {
            return false;
        }
        for (class_1792 fish : fishes) {
            class_1799 fishStack = new class_1799((class_1935)fish);
            if (data.hasFishUnlocked(fishStack)) continue;
            return false;
        }
        return true;
    }

    public static void unlockPage(class_3222 player, JournalPage page) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        if (!data.hasPageUnlocked(page)) {
            data.unlockPage(page);
            Tide.NETWORK.sendToPlayer(new ShowToastMsg((class_2561)class_2561.method_43471((String)"newpage.toast.title"), TideUtils.getPageToastDesc(page), TideUtils.getPageToastIcon(page)), player);
            data.syncTo(player);
        }
    }

    public static void unlockFishForCategory(class_3222 player, String name) {
        TidePlayerData data = TidePlayerData.getOrCreate(player);
        JournalPage page = TideUtils.getPageByName(name);
        if (page == null) {
            return;
        }
        List<class_1792> fishes = TideUtils.getFishFromProfileList(page.getAllProfiles());
        for (class_1792 fish : fishes) {
            if (data.hasFishUnlocked(fish.method_7854())) continue;
            data.unlockFish(fish.method_7854());
        }
        TideUtils.checkPageCompletion(data, page, player);
        data.syncTo(player);
    }

    public static boolean isInPage(String pageName, class_1799 stack) {
        List<class_1792> fishes = TideUtils.getFishFromPageName(pageName);
        if (fishes == null) {
            return false;
        }
        return fishes.contains(stack.method_7909());
    }

    public static class_2561 removeRawTextInName(class_2561 initialName) {
        String[] splitName = class_2561.method_43471((String)initialName.getString()).getString().split("Raw ");
        StringBuilder nameBuilder = new StringBuilder();
        for (String string : splitName) {
            nameBuilder.append(string);
        }
        return class_2561.method_43470((String)nameBuilder.toString());
    }

    public static class_1799 getPageToastIcon(JournalPage page) {
        return page.icon();
    }

    public static class_2561 getPageToastDesc(JournalPage page) {
        return class_2561.method_43471((String)page.title());
    }

    public static List<class_1792> getFishFromProfileList(List<JournalLayout.Profile> profiles) {
        return profiles.stream().map(profile -> (class_1792)class_7923.field_41178.method_10223(new class_2960(profile.fishItem()))).toList();
    }

    public static List<class_1792> getFishFromPageName(String name) {
        JournalPage page = TideUtils.getPageByName(name);
        if (page == null) {
            return null;
        }
        return TideUtils.getFishFromProfileList(page.getAllProfiles());
    }

    public static JournalPage getPageByName(String name) {
        JournalLayout.Page pageConfig = Tide.JOURNAL.getPageConfigs().stream().filter(config -> config.id().matches(name)).findFirst().orElse(null);
        if (pageConfig == null) {
            return null;
        }
        return new JournalPage(pageConfig);
    }

    public static JournalLayout.Profile getProfileFromItem(class_1799 item) {
        return Tide.JOURNAL.getProfileConfigs().stream().filter(config -> item.method_31574((class_1792)class_7923.field_41178.method_10223(new class_2960(config.fishItem())))).findFirst().orElse(null);
    }
}

