/*
 * Decompiled with CFR 0.152.
 */
package com.github.crimsondawn45.fabricshieldlib.initializers;

import com.github.crimsondawn45.fabricshieldlib.initializers.FabricShieldLib;
import com.github.crimsondawn45.fabricshieldlib.lib.object.FabricBannerShieldItem;
import com.github.crimsondawn45.fabricshieldlib.lib.object.FabricShield;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2573;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4730;
import net.minecraft.class_5601;
import net.minecraft.class_600;
import net.minecraft.class_630;
import net.minecraft.class_823;
import net.minecraft.class_918;

public class FabricShieldLibClient
implements ClientModInitializer {
    public static final class_5601 fabric_banner_shield_model_layer = new class_5601(new class_2960("fabricshieldlib", "fabric_banner_shield"), "main");

    public void onInitializeClient() {
        ItemTooltipCallback.EVENT.register((stack, context, tooltip) -> {
            if (FabricShieldLib.config.enable_tooltips) {
                if (stack.method_7909() instanceof FabricShield) {
                    FabricShield shield = (FabricShield)stack.method_7909();
                    FabricShieldLibClient.getCooldownTooltip(stack, context, tooltip, shield.getCooldownTicks());
                }
                if (stack.method_7909().equals(class_1802.field_8255)) {
                    FabricShieldLibClient.getCooldownTooltip(stack, context, tooltip, 100);
                }
            }
        });
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            FabricShieldLib.logger.warn("FABRIC SHIELD LIB DEVELOPMENT CODE RAN!!!, if you are not in a development environment this is very bad! Client side banner code ran!");
            EntityModelLayerRegistry.registerModelLayer((class_5601)fabric_banner_shield_model_layer, class_600::method_32039);
            ClientSpriteRegistryCallback.event((class_2960)class_1059.field_5275).register((atlasTexture, registry) -> {
                registry.register(new class_2960("fabricshieldlib", "entity/fabric_banner_shield_base"));
                registry.register(new class_2960("fabricshieldlib", "entity/fabric_banner_shield_base_nopattern"));
            });
        }
    }

    public static void renderBanner(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_600 model, class_4730 base, class_4730 base_nopattern) {
        boolean bl = stack.method_7941("BlockEntityTag") != null;
        matrices.method_22903();
        matrices.method_22905(1.0f, -1.0f, -1.0f);
        class_4730 spriteIdentifier = bl ? base : base_nopattern;
        class_4588 vertexConsumer = spriteIdentifier.method_24148().method_24108(class_918.method_29711((class_4597)vertexConsumers, (class_1921)model.method_23500(spriteIdentifier.method_24144()), (boolean)true, (boolean)stack.method_7958()));
        model.method_23775().method_22699(matrices, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (bl) {
            List list = class_2573.method_24280((class_1767)FabricBannerShieldItem.getColor(stack), (class_2499)class_2573.method_24281((class_1799)stack));
            class_823.method_23802((class_4587)matrices, (class_4597)vertexConsumers, (int)light, (int)overlay, (class_630)model.method_23774(), (class_4730)spriteIdentifier, (boolean)false, (List)list, (boolean)stack.method_7958());
        } else {
            model.method_23774().method_22699(matrices, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrices.method_22909();
    }

    public static List<class_2561> getCooldownTooltip(class_1799 stack, class_1836 context, List<class_2561> tooltip, int cooldownTicks) {
        ArrayList<class_2561> advanced = new ArrayList<class_2561>();
        if (context.method_8035()) {
            String strText;
            class_2561 text;
            int i;
            if (stack.method_7986()) {
                for (i = 0; i < tooltip.size(); ++i) {
                    text = tooltip.get(i);
                    strText = text.getString();
                    if (!strText.startsWith("Durability")) continue;
                    advanced.add(text);
                    tooltip.remove(i);
                }
            }
            for (i = 0; i < tooltip.size(); ++i) {
                text = tooltip.get(i);
                strText = text.getString();
                if (!class_2960.method_20207((String)strText)) continue;
                advanced.add(text);
                tooltip.remove(i);
            }
            if (stack.method_7985()) {
                for (i = 0; i < tooltip.size(); ++i) {
                    text = tooltip.get(i);
                    strText = text.getString();
                    if (!strText.startsWith("NBT: ")) continue;
                    advanced.add(text);
                    tooltip.remove(i);
                }
            }
        }
        tooltip.add((class_2561)new class_2585(""));
        tooltip.add((class_2561)new class_2588("fabricshieldlib.shield_tooltip.start").method_10852((class_2561)new class_2585(":")).method_27692(class_124.field_1080));
        String cooldown = String.valueOf((Object)((double)cooldownTicks / 20.0));
        char[] splitCooldown = cooldown.toCharArray();
        if (splitCooldown.length >= 3 && splitCooldown[2] == '0' && splitCooldown.length < 4) {
            cooldown = String.valueOf(splitCooldown[0]);
        }
        tooltip.add((class_2561)new class_2585(" " + cooldown + "s ").method_27692(class_124.field_1077).method_10852((class_2561)new class_2588("fabricshieldlib.shield_tooltip.end")));
        if (context.method_8035()) {
            tooltip.addAll(advanced);
        }
        return tooltip;
    }
}

