/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture;

import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.DownloadQueue;
import me.chrr.camerapture.PlatformAdapter;
import me.chrr.camerapture.config.ConfigManager;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.gui.AlbumLecternScreenHandler;
import me.chrr.camerapture.gui.AlbumScreenHandler;
import me.chrr.camerapture.gui.PictureFrameScreenHandler;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureCloningRecipe;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.net.NetworkAdapter;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.RequestDownloadPacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import me.chrr.camerapture.picture.ServerPictureStore;
import me.chrr.camerapture.picture.StoredPicture;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Camerapture {
    public static final String MOD_ID = "camerapture";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Executor EXECUTOR = runnable -> new Thread(runnable, "Camerapture Worker").start();
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    public static final PlatformAdapter PLATFORM = ServiceLoader.load(PlatformAdapter.class).iterator().next();
    public static final NetworkAdapter NETWORK = PLATFORM.createNetworkAdapter();
    public static final int SECTION_SIZE = 30000;
    public static Item CAMERA = new CameraItem();
    public static final SoundEvent CAMERA_SHUTTER = SoundEvent.m_262824_((ResourceLocation)Camerapture.id("camera_shutter"));
    public static final ResourceLocation PICTURES_TAKEN = Camerapture.id("pictures_taken");
    public static Item PICTURE = new PictureItem();
    public static final SimpleCraftingRecipeSerializer<PictureCloningRecipe> PICTURE_CLONING = new SimpleCraftingRecipeSerializer(PictureCloningRecipe::new);
    public static final Item ALBUM = new AlbumItem();
    public static final MenuType<AlbumScreenHandler> ALBUM_SCREEN_HANDLER = new MenuType(AlbumScreenHandler::new, FeatureFlagSet.m_246902_());
    public static final MenuType<AlbumLecternScreenHandler> ALBUM_LECTERN_SCREEN_HANDLER = new MenuType((syncId, playerInventory) -> new AlbumLecternScreenHandler(syncId), FeatureFlagSet.m_246902_());
    public static final EntityType<PictureFrameEntity> PICTURE_FRAME = EntityType.Builder.m_20704_(PictureFrameEntity::new, (MobCategory)MobCategory.MISC).m_20702_(10).m_20712_("picture_frame");
    public static final MenuType<PictureFrameScreenHandler> PICTURE_FRAME_SCREEN_HANDLER = new MenuType((syncId, pi) -> new PictureFrameScreenHandler(syncId), FeatureFlagSet.m_246902_());

    public static void registerPacketHandlers() {
        NETWORK.onReceiveFromClient(NewPicturePacket.class, (packet, player) -> {
            CameraItem.HeldCamera camera = CameraItem.find((Player)player, false);
            if (camera == null) {
                return;
            }
            if (!player.m_7500_() && ContainerHelper.m_18956_((Container)player.m_150109_(), stack -> stack.m_150930_(Items.f_42516_), (int)1, (boolean)false) != 1) {
                return;
            }
            if (CameraItem.isActive(camera.stack())) {
                player.m_284548_().m_6269_(null, (Entity)player, CAMERA_SHUTTER, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            CameraItem.setActive(camera.stack(), false);
            player.m_36335_().m_41524_(CAMERA, 60);
            player.m_21011_(camera.hand(), true);
            player.m_36220_(PICTURES_TAKEN);
            UUID id = ServerPictureStore.getInstance().reserveId();
            NETWORK.sendToClient((ServerPlayer)player, new RequestUploadPacket(id));
        });
        ConcurrentHashMap collectors = new ConcurrentHashMap();
        NETWORK.onReceiveFromClient(UploadPartialPicturePacket.class, (packet, player) -> {
            ByteCollector collector;
            if (!ServerPictureStore.getInstance().isReserved(packet.uuid())) {
                LOGGER.error("{} tried to send a byte section for an unreserved UUID", (Object)player.m_7755_().toString());
                return;
            }
            if (packet.bytesLeft() > Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes) {
                LOGGER.error("{} sent a picture exceeding the size limit", (Object)player.m_7755_().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
            if (!(collector = collectors.computeIfAbsent(packet.uuid(), uuid -> new ByteCollector(bytes -> {
                collectors.remove(uuid);
                EXECUTOR.execute(() -> {
                    try {
                        MinecraftServer server = player.m_20194_();
                        if (server == null) {
                            return;
                        }
                        ServerPictureStore.getInstance().put(server, (UUID)uuid, new StoredPicture((byte[])bytes));
                        ItemStack picture = PictureItem.create(player.m_7755_().getString(), uuid);
                        server.execute(() -> player.m_150109_().m_150079_(picture));
                    }
                    catch (Exception e) {
                        LOGGER.error("failed to save picture from {}", (Object)player.m_7755_().getString(), (Object)e);
                        player.m_5661_((Component)Component.m_237115_((String)"text.camerapture.picture_failed").m_130940_(ChatFormatting.RED), false);
                    }
                });
            }))).push(packet.bytes(), packet.bytesLeft())) {
                LOGGER.error("{} sent a malformed byte section", (Object)player.m_7755_().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
            if (collector.getCurrentLength() > Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes) {
                LOGGER.error("{} sent a picture exceeding the size limit", (Object)player.m_7755_().getString());
                collectors.remove(packet.uuid());
                ServerPictureStore.getInstance().unreserveId(packet.uuid());
            }
        });
        NETWORK.onReceiveFromClient(RequestDownloadPacket.class, (packet, player) -> {
            try {
                StoredPicture picture = ServerPictureStore.getInstance().get(player.m_20194_(), packet.uuid());
                if (picture == null) {
                    LOGGER.warn("{} requested a picture with an unknown UUID", (Object)player.m_7755_().getString());
                    NETWORK.sendToClient((ServerPlayer)player, new PictureErrorPacket(packet.uuid()));
                    return;
                }
                DownloadQueue.getInstance().send((ServerPlayer)player, packet.uuid(), picture);
            }
            catch (Exception e) {
                LOGGER.error("failed to load picture for {}", (Object)player.m_7755_().getString(), (Object)e);
                NETWORK.sendToClient((ServerPlayer)player, new PictureErrorPacket(packet.uuid()));
            }
        });
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.m_214293_((String)MOD_ID, (String)path);
    }
}

