/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.entity;

import me.chrr.camerapture.Camerapture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ResizableDecorationEntity
extends Entity {
    public static final double THICKNESS = 0.0625;
    private static final EntityDataAccessor<Integer> FRAME_WIDTH = SynchedEntityData.m_135353_(ResizableDecorationEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FRAME_HEIGHT = SynchedEntityData.m_135353_(ResizableDecorationEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Direction facing = Direction.SOUTH;
    private BlockPos attachmentPos;
    private int obstructionCheckCounter = 0;

    public ResizableDecorationEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(FRAME_WIDTH, (Object)1);
        this.m_20088_().m_135372_(FRAME_HEIGHT, (Object)1);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (data.equals(FRAME_WIDTH) || data.equals(FRAME_HEIGHT)) {
            this.updateBoundingBox();
        }
    }

    public void resetObstructionCheckCounter() {
        this.obstructionCheckCounter = 0;
    }

    public void m_8119_() {
        if (this.m_9236_() instanceof ServerLevel && Camerapture.CONFIG_MANAGER.getConfig().server.checkFramePosition && this.obstructionCheckCounter++ == 100) {
            this.obstructionCheckCounter = 0;
            if (!this.canStayAttached() && !this.m_213877_()) {
                this.m_146870_();
                this.onBreak(null);
            }
        }
    }

    public BlockPos getAttachmentPos() {
        return this.attachmentPos;
    }

    public void setAttachmentPos(BlockPos attachmentPos) {
        this.attachmentPos = attachmentPos;
        this.updateBoundingBox();
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
        this.m_146922_(this.facing.m_122416_() * 90);
        this.f_19859_ = this.m_146908_();
        this.updateBoundingBox();
    }

    public int getFrameWidth() {
        return (Integer)this.m_20088_().m_135370_(FRAME_WIDTH);
    }

    public void setFrameWidth(int width) {
        this.m_20088_().m_135381_(FRAME_WIDTH, (Object)width);
        this.updateBoundingBox();
    }

    public int getFrameHeight() {
        return (Integer)this.m_20088_().m_135370_(FRAME_HEIGHT);
    }

    public void setFrameHeight(int height) {
        this.m_20088_().m_135381_(FRAME_HEIGHT, (Object)height);
        this.updateBoundingBox();
    }

    protected void updateBoundingBox() {
        if (this.facing == null) {
            return;
        }
        Vec3 center = this.attachmentPos.m_252807_();
        center = center.m_82546_(new Vec3((double)this.facing.m_122429_(), 0.0, (double)this.facing.m_122431_()).m_82490_(0.46875));
        this.m_20343_(center.f_82479_, center.f_82480_, center.f_82481_);
        Direction parallel = this.facing.m_122428_();
        if (this.facing.m_122434_() == Direction.Axis.Z) {
            Vec3 p1 = center.m_82492_((double)parallel.m_122429_() * 0.5, 0.5, 0.03125);
            Vec3 p2 = p1.m_82520_((double)(parallel.m_122429_() * this.getFrameWidth()), (double)this.getFrameHeight(), 0.0625);
            this.m_20011_(new AABB(p1, p2));
        } else {
            Vec3 p1 = center.m_82492_(0.03125, 0.5, (double)parallel.m_122431_() * 0.5);
            Vec3 p2 = p1.m_82520_(0.0625, (double)this.getFrameHeight(), (double)(parallel.m_122431_() * this.getFrameWidth()));
            this.m_20011_(new AABB(p1, p2));
        }
        this.resetObstructionCheckCounter();
    }

    public Direction m_6350_() {
        return this.getFacing();
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean canStayAttached() {
        if (!Camerapture.CONFIG_MANAGER.getConfig().server.checkFramePosition) {
            return true;
        }
        if (!this.m_9236_().m_45786_((Entity)this)) {
            return false;
        }
        BlockPos blockPos = this.attachmentPos.m_121945_(this.facing.m_122424_());
        Direction direction = this.facing.m_122428_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.getFrameWidth(); ++x) {
            for (int y = 0; y < this.getFrameHeight(); ++y) {
                mutable.m_122190_((Vec3i)blockPos).m_122175_(direction, x).m_122175_(Direction.UP, y);
                BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutable);
                if (blockState.m_280296_() || DiodeBlock.m_52586_((BlockState)blockState)) continue;
                return false;
            }
        }
        return this.m_9236_().m_6249_((Entity)this, this.m_20191_(), entity -> entity instanceof HangingEntity || entity instanceof ResizableDecorationEntity).isEmpty();
    }

    public boolean m_7313_(Entity attacker) {
        if (attacker instanceof Player) {
            Player playerEntity = (Player)attacker;
            return !this.m_9236_().m_7966_(playerEntity, this.m_20183_()) || this.m_6469_(this.m_269291_().m_269075_(playerEntity), 0.0f);
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_213877_() && !this.m_9236_().f_46443_) {
            this.m_6074_();
            this.m_5834_();
            this.onBreak(source.m_7639_());
        }
        return true;
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        if (this.m_9236_() instanceof ServerLevel && !this.m_213877_() && movement.m_82556_() > 0.0) {
            this.m_6074_();
            this.onBreak(null);
        }
    }

    public void m_5997_(double deltaX, double deltaY, double deltaZ) {
        if (this.m_9236_() instanceof ServerLevel && !this.m_213877_() && deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ > 0.0) {
            this.m_6074_();
            this.onBreak(null);
        }
    }

    public void m_6034_(double x, double y, double z) {
        this.attachmentPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        this.updateBoundingBox();
        this.f_19812_ = true;
    }

    public float m_7890_(Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                this.setFacing(this.getFacing().m_122424_());
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.setFacing(this.getFacing().m_122428_());
                break;
            }
            case CLOCKWISE_90: {
                this.setFacing(this.getFacing().m_122427_());
            }
        }
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> this.m_146908_() + 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> this.m_146908_() + 90.0f;
            case Rotation.CLOCKWISE_90 -> this.m_146908_() + 270.0f;
            default -> this.m_146908_();
        };
    }

    public ItemEntity m_5552_(ItemStack stack, float yOffset) {
        Vec3 center = this.m_20191_().m_82399_();
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), center.f_82479_ + (double)((float)this.getFacing().m_122429_() * 0.15f), center.f_82480_ + (double)yOffset, center.f_82481_ + (double)((float)this.getFacing().m_122431_() * 0.15f), stack);
        itemEntity.m_32060_();
        this.m_9236_().m_7967_((Entity)itemEntity);
        return itemEntity;
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("TileX", this.attachmentPos.m_123341_());
        nbt.m_128405_("TileY", this.attachmentPos.m_123342_());
        nbt.m_128405_("TileZ", this.attachmentPos.m_123343_());
        nbt.m_128344_("Facing", (byte)this.getFacing().m_122411_());
        nbt.m_128405_("Width", this.getFrameWidth());
        nbt.m_128405_("Height", this.getFrameHeight());
    }

    public void m_7378_(CompoundTag nbt) {
        BlockPos blockPos = new BlockPos(nbt.m_128451_("TileX"), nbt.m_128451_("TileY"), nbt.m_128451_("TileZ"));
        if (!blockPos.m_123314_((Vec3i)this.m_20183_(), 16.0)) {
            Camerapture.LOGGER.error("hanging entity at invalid position: {}", (Object)blockPos);
        } else {
            this.attachmentPos = blockPos;
        }
        this.setFacing(Direction.m_122376_((int)nbt.m_128445_("Facing")));
        this.setFrameWidth(nbt.m_128451_("Width"));
        this.setFrameHeight(nbt.m_128451_("Height"));
        this.updateBoundingBox();
    }

    public float m_6961_(Mirror mirror) {
        return this.m_7890_(mirror.m_54846_(this.getFacing()));
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
    }

    public void m_6210_() {
    }

    public abstract void onPlace();

    public abstract void onBreak(@Nullable Entity var1);
}

