/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.forge;

import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.DownloadQueue;
import me.chrr.camerapture.config.Config;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.forge.CameraptureClientForge;
import me.chrr.camerapture.forge.ForgeNetworkAdapter;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.net.clientbound.DownloadPartialPicturePacket;
import me.chrr.camerapture.net.clientbound.PictureErrorPacket;
import me.chrr.camerapture.net.clientbound.RequestUploadPacket;
import me.chrr.camerapture.net.clientbound.SyncConfigPacket;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.RequestDownloadPacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="camerapture")
public class CameraptureForge {
    public CameraptureForge() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> new CameraptureClientForge(modBus));
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        Camerapture.CONFIG_MANAGER.load();
        this.registerPackets();
    }

    @SubscribeEvent
    public void registerContent(RegisterEvent event) {
        event.register(Registries.f_256913_, registry -> registry.register(CameraItem.KEY, (Object)Camerapture.CAMERA));
        event.register(Registries.f_256840_, registry -> registry.register(Camerapture.id("camera_shutter"), (Object)Camerapture.CAMERA_SHUTTER));
        event.register(Registries.f_256887_, registry -> {
            registry.register(Camerapture.PICTURES_TAKEN, (Object)Camerapture.PICTURES_TAKEN);
            Stats.f_12988_.m_12899_((Object)Camerapture.PICTURES_TAKEN, StatFormatter.f_12873_);
        });
        event.register(Registries.f_256913_, registry -> registry.register(PictureItem.KEY, (Object)Camerapture.PICTURE));
        event.register(Registries.f_256764_, registry -> registry.register(Camerapture.id("picture_cloning"), Camerapture.PICTURE_CLONING));
        event.register(Registries.f_256913_, registry -> registry.register(AlbumItem.KEY, (Object)Camerapture.ALBUM));
        event.register(Registries.f_256798_, registry -> registry.register(Camerapture.id("album"), Camerapture.ALBUM_SCREEN_HANDLER));
        event.register(Registries.f_256798_, registry -> registry.register(Camerapture.id("album_lectern"), Camerapture.ALBUM_LECTERN_SCREEN_HANDLER));
        event.register(Registries.f_256939_, registry -> registry.register(PictureFrameEntity.KEY, Camerapture.PICTURE_FRAME));
        event.register(Registries.f_256798_, registry -> registry.register(Camerapture.id("picture_frame"), Camerapture.PICTURE_FRAME_SCREEN_HANDLER));
    }

    public void registerPackets() {
        ForgeNetworkAdapter networkAdapter = (ForgeNetworkAdapter)Camerapture.NETWORK;
        networkAdapter.registerServerBound(NewPicturePacket.class, NewPicturePacket.NET_CODEC);
        networkAdapter.registerServerBound(RequestDownloadPacket.class, RequestDownloadPacket.NET_CODEC);
        networkAdapter.registerServerBound(UploadPartialPicturePacket.class, UploadPartialPicturePacket.NET_CODEC);
        networkAdapter.registerClientBound(PictureErrorPacket.class, PictureErrorPacket.NET_CODEC);
        networkAdapter.registerClientBound(RequestUploadPacket.class, RequestUploadPacket.NET_CODEC);
        networkAdapter.registerClientBound(SyncConfigPacket.class, SyncConfigPacket.NET_CODEC);
        networkAdapter.registerClientBound(DownloadPartialPicturePacket.class, DownloadPartialPicturePacket.NET_CODEC);
        Camerapture.registerPacketHandlers();
    }

    @SubscribeEvent
    public void fillCreativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.m_246326_((ItemLike)Camerapture.CAMERA);
            event.m_246326_((ItemLike)Camerapture.ALBUM);
        }
    }

    private static class ServerEvents {
        private ServerEvents() {
        }

        @SubscribeEvent
        public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Config config = Camerapture.CONFIG_MANAGER.getConfig();
            Camerapture.NETWORK.sendToClient((ServerPlayer)event.getEntity(), new SyncConfigPacket(config.server.maxImageBytes, config.server.maxImageResolution, config.server.allowUploading));
        }

        @SubscribeEvent
        public void onServerStarted(ServerStartedEvent event) {
            DownloadQueue.getInstance().start(Camerapture.CONFIG_MANAGER.getConfig().server.msPerPicture);
        }

        @SubscribeEvent
        public void onServerStopping(ServerStoppingEvent event) {
            DownloadQueue.getInstance().stop();
        }
    }
}

