/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.forge;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.net.NetCodec;
import me.chrr.camerapture.net.NetworkAdapter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class ForgeNetworkAdapter
implements NetworkAdapter {
    private static final String PROTOCOL_VERSION = "2";
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)Camerapture.id("main"), () -> "2", "2"::equals, "2"::equals);
    private static int nextId = 0;
    private final Map<Class<?>, ServerPacketType<?>> serverPackets = new HashMap();
    private final Map<Class<?>, ClientPacketType<?>> clientPackets = new HashMap();

    public <P> void registerServerBound(Class<P> clazz, NetCodec<P> netCodec) {
        ClientPacketType type = new ClientPacketType(netCodec, new ArrayList());
        this.clientPackets.put(clazz, type);
        CHANNEL.registerMessage(nextId++, clazz, (packet, buf) -> ForgeNetworkAdapter.encodePacket(packet, buf, type.netCodec()), buf -> ForgeNetworkAdapter.decodePacket(buf, type.netCodec()), (packet, context) -> {
            if (packet != null) {
                type.handlers().forEach(arg_0 -> ForgeNetworkAdapter.lambda$registerServerBound$3(packet, (Supplier)context, arg_0));
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public <P> void registerClientBound(Class<P> clazz, NetCodec<P> netCodec) {
        ServerPacketType type = new ServerPacketType(netCodec, new ArrayList());
        this.serverPackets.put(clazz, type);
        CHANNEL.registerMessage(nextId++, clazz, (packet, buf) -> ForgeNetworkAdapter.encodePacket(packet, buf, type.netCodec()), buf -> ForgeNetworkAdapter.decodePacket(buf, type.netCodec()), (packet, context) -> {
            if (packet != null) {
                type.handlers().forEach(handler -> handler.accept(packet));
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    @Override
    public <P> void sendToClient(ServerPlayer player, P packet) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    @Override
    public <P> void onReceiveFromClient(Class<P> clazz, BiConsumer<P, ServerPlayer> handler) {
        this.getClientPacketType(clazz).handlers().add(handler);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <P> void sendToServer(P packet) {
        CHANNEL.sendToServer(packet);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <P> void onReceiveFromServer(Class<P> clazz, Consumer<P> handler) {
        this.getServerPacketType(clazz).handlers().add(handler);
    }

    private static <P> void encodePacket(P packet, FriendlyByteBuf buf, NetCodec<P> netCodec) {
        MapCodec dataCodec = netCodec.codec().fieldOf("data");
        DataResult result = dataCodec.encoder().encodeStart((DynamicOps)NbtOps.f_128958_, packet);
        buf.m_130079_((CompoundTag)result.get().left().orElseThrow());
    }

    @Nullable
    private static <P> P decodePacket(FriendlyByteBuf buf, NetCodec<P> netCodec) {
        MapCodec dataCodec = netCodec.codec().fieldOf("data");
        DataResult result = dataCodec.decoder().decode((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_());
        if (result.error().isPresent()) {
            Camerapture.LOGGER.error("failed to decode packet: {}", (Object)((DataResult.PartialResult)result.error().get()).message());
            return null;
        }
        return (P)((Pair)result.result().orElseThrow()).getFirst();
    }

    private <P> ServerPacketType<P> getServerPacketType(Class<P> clazz) {
        ServerPacketType<?> type = this.serverPackets.get(clazz);
        return type;
    }

    private <P> ClientPacketType<P> getClientPacketType(Class<P> clazz) {
        ClientPacketType<?> type = this.clientPackets.get(clazz);
        return type;
    }

    private static /* synthetic */ void lambda$registerServerBound$3(Object packet, Supplier context, BiConsumer handler) {
        handler.accept(packet, ((NetworkEvent.Context)context.get()).getSender());
    }

    private record ClientPacketType<P>(NetCodec<P> netCodec, List<BiConsumer<P, ServerPlayer>> handlers) {
    }

    private record ServerPacketType<P>(NetCodec<P> netCodec, List<Consumer<P>> handlers) {
    }
}

