/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.picture.PictureTaker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public final class CameraViewFinder
extends Enum<CameraViewFinder> {
    private static final SimpleDateFormat SDF_DATE;
    private static final /* synthetic */ CameraViewFinder[] $VALUES;

    public static CameraViewFinder[] values() {
        return (CameraViewFinder[])$VALUES.clone();
    }

    public static CameraViewFinder valueOf(String name) {
        return Enum.valueOf(CameraViewFinder.class, name);
    }

    public static void drawCameraViewFinder(GuiGraphics context, Font textRenderer) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        int width = context.m_280182_();
        int height = context.m_280206_();
        CameraViewFinder.drawViewFinder(context, 10, 10, width - 10, height - 10, 2, 30);
        CameraViewFinder.drawViewFinder(context, width / 2 - 20, height / 2 - 20, width / 2 + 20, height / 2 + 20, 1, 10);
        CameraViewFinder.drawZoomBar(context, textRenderer, width - 10, height / 2 - height / 6, height / 3);
        Objects.requireNonNull(textRenderer);
        int fh = 9;
        int textX = 25;
        int textY = height - 25;
        context.m_280614_(textRenderer, (Component)Component.m_237110_((String)"text.camerapture.date", (Object[])new Object[]{SDF_DATE.format(new Date())}), textX, textY - fh, -1, false);
        if (!CameraItem.canTakePicture((Player)player)) {
            if (System.currentTimeMillis() % 1000L < 500L) {
                int w = textRenderer.m_92852_((FormattedText)Component.m_237115_((String)"text.camerapture.no_paper"));
                int x = width / 2 - w / 2;
                int y = height / 2 + 32;
                context.m_280614_(textRenderer, (Component)Component.m_237115_((String)"text.camerapture.no_paper"), x, y, -65536, false);
            }
        } else {
            int paper = CameraItem.getPaperInInventory((Player)player);
            MutableComponent text = Component.m_237110_((String)"text.camerapture.paper_available", (Object[])new Object[]{paper});
            int w = textRenderer.m_92852_((FormattedText)text);
            int x = width - 25 - w;
            int y = height - 25 - fh;
            context.m_280614_(textRenderer, (Component)text, x, y, -1, false);
        }
    }

    private static void drawViewFinder(GuiGraphics context, int x1, int y1, int x2, int y2, int thickness, int length) {
        context.m_280509_(x1, y1, x1 + length, y1 + thickness, -1);
        context.m_280509_(x1, y1, x1 + thickness, y1 + length, -1);
        context.m_280509_(x2 - length, y1, x2, y1 + thickness, -1);
        context.m_280509_(x2 - thickness, y1, x2, y1 + length, -1);
        context.m_280509_(x1, y2 - thickness, x1 + length, y2, -1);
        context.m_280509_(x1, y2 - length, x1 + thickness, y2, -1);
        context.m_280509_(x2 - length, y2 - thickness, x2, y2, -1);
        context.m_280509_(x2 - thickness, y2 - length, x2, y2, -1);
    }

    private static void drawZoomBar(GuiGraphics context, Font textRenderer, int x, int y, int height) {
        int ty;
        int ticks = height / 10;
        for (int i = 0; i < ticks; ++i) {
            ty = y + height * i / (ticks - 1);
            context.m_280509_(x - 6, ty, x, ty + 1, -1342177281);
        }
        float zoomProgress = 1.0f - (PictureTaker.getInstance().zoomLevel - 1.0f) / 5.0f;
        ty = y + (int)((float)height * zoomProgress);
        context.m_280509_(x - 10, ty - 1, x, ty + 1, -1);
        String zoomLevel = String.format("%.1fx", Float.valueOf(PictureTaker.getInstance().zoomLevel));
        int textWidth = textRenderer.m_92895_(zoomLevel);
        context.m_280056_(textRenderer, zoomLevel, x - 12 - textWidth, ty - 4, -1, false);
    }

    private static /* synthetic */ CameraViewFinder[] $values() {
        return new CameraViewFinder[0];
    }

    static {
        $VALUES = CameraViewFinder.$values();
        SDF_DATE = new SimpleDateFormat("yyyy/MM/dd");
    }
}

