/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.InGameScreen;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.picture.PictureTaker;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class UploadScreen
extends InGameScreen {
    private static final ResourceLocation TEXTURE = Camerapture.id("textures/gui/upload_picture.png");
    private static final int backgroundWidth = 256;
    private static final int backgroundHeight = 128;
    private PlainTextButton browseButton;

    public UploadScreen() {
        super((Component)Component.m_237115_((String)"text.camerapture.upload_picture.title").m_130940_(ChatFormatting.BOLD));
    }

    protected void m_7856_() {
        super.m_7856_();
        MutableComponent text = Component.m_237115_((String)"text.camerapture.upload_picture.browse").m_130940_(ChatFormatting.UNDERLINE);
        int w = this.f_96547_.m_92852_((FormattedText)text);
        int n = this.f_96543_ / 2 - w / 2;
        int n2 = this.f_96544_ / 2;
        Objects.requireNonNull(this.f_96547_);
        int n3 = n2 + 9 + 4;
        Objects.requireNonNull(this.f_96547_);
        this.browseButton = (PlainTextButton)this.m_142416_((GuiEventListener)new PlainTextButton(n, n3, w, 9, (Component)text, button -> this.browseFile(), this.f_96547_));
    }

    @Override
    public void renderScreen(GuiGraphics context, int mouseX, int mouseY, float delta) {
        boolean canTakePicture;
        MutableComponent description = Component.m_237115_((String)"text.camerapture.upload_picture.description");
        context.m_280163_(TEXTURE, this.f_96543_ / 2 - 128, this.f_96544_ / 2 - 64, 0.0f, 0.0f, 256, 128, 256, 256);
        int n = this.f_96543_ / 2;
        int n2 = this.f_96544_ / 2;
        Objects.requireNonNull(this.f_96547_);
        context.m_280653_(this.f_96547_, this.f_96539_, n, n2 - 9 - 16, 0xFFFFFF);
        this.browseButton.f_93624_ = canTakePicture = this.f_96541_ != null && this.f_96541_.f_91074_ != null && CameraItem.canTakePicture((Player)this.f_96541_.f_91074_);
        if (!canTakePicture) {
            if (System.currentTimeMillis() % 1000L < 500L) {
                int n3 = this.f_96544_ / 2;
                Objects.requireNonNull(this.f_96547_);
                int y = n3 + 9 + 4;
                context.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"text.camerapture.no_paper"), this.f_96543_ / 2, y, -65536);
            }
        } else {
            context.m_280653_(this.f_96547_, (Component)description, this.f_96543_ / 2, this.f_96544_ / 2, 0xFFFFFF);
        }
    }

    public void m_7400_(List<Path> paths) {
        for (Path path : paths) {
            if (!this.tryUpload(path)) continue;
            this.m_7379_();
            return;
        }
    }

    private void browseFile() {
        new Thread(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                PointerBuffer filter = stack.mallocPointer(1);
                filter.put(stack.UTF8((CharSequence)"*"));
                filter.flip();
                String path = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)"Open Image", (CharSequence)"", (PointerBuffer)filter, (CharSequence)"Image File", (boolean)false);
                if (path == null) {
                    return;
                }
                try {
                    if (this.tryUpload(Path.of(path, new String[0]))) {
                        Minecraft.m_91087_().m_201446_(() -> ((UploadScreen)this).m_7379_());
                    }
                }
                catch (InvalidPathException e) {
                    Camerapture.LOGGER.error("tinyfd returned invalid path", (Throwable)e);
                }
            }
        }).start();
    }

    private boolean tryUpload(Path path) {
        boolean canTakePicture;
        boolean bl = canTakePicture = this.f_96541_ != null && this.f_96541_.f_91074_ != null && CameraItem.canTakePicture((Player)this.f_96541_.f_91074_);
        if (!canTakePicture) {
            return false;
        }
        PictureTaker.getInstance().tryUploadFile(path);
        return true;
    }
}

