/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.UUID;
import me.chrr.camerapture.entity.PictureFrameEntity;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.LoadingDotsText;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class PictureFrameEntityRenderer
extends EntityRenderer<PictureFrameEntity> {
    public static final double DISTANCE_FROM_WALL = 0.01;

    public PictureFrameEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(PictureFrameEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        PictureItem.PictureData pictureData;
        EntityHitResult hitResult;
        HitResult hitResult2;
        boolean shouldRenderOutline;
        matrices.m_85836_();
        Vec3 offset = this.getPositionOffset(entity, tickDelta).m_82548_();
        matrices.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        matrices.m_85837_(0.5 - (double)entity.getFrameWidth() / 2.0, -0.5 + (double)entity.getFrameHeight() / 2.0, 0.0);
        Minecraft client = Minecraft.m_91087_();
        boolean bl = shouldRenderOutline = !this.f_114476_.f_114360_.f_92062_ && CameraItem.find((Player)client.f_91074_, true) == null && (hitResult2 = client.f_91077_) instanceof EntityHitResult && (hitResult = (EntityHitResult)hitResult2).m_82443_() == entity;
        if (shouldRenderOutline) {
            this.renderOutline(matrices, vertexConsumers, entity.getFrameWidth(), entity.getFrameHeight());
        }
        matrices.m_85837_(0.0, 0.0, 0.02625);
        UUID pictureId = null;
        ItemStack stack = entity.getItemStack();
        if (stack != null && (pictureData = PictureItem.getPictureData(stack)) != null) {
            pictureId = pictureData.id();
        }
        if (pictureId == null) {
            this.renderErrorText(matrices, vertexConsumers, light);
        } else {
            RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(pictureId);
            if (picture == null || picture.getStatus() == RemotePicture.Status.ERROR) {
                this.renderErrorText(matrices, vertexConsumers, light);
            } else if (picture.getStatus() == RemotePicture.Status.FETCHING) {
                this.renderFetching(matrices, vertexConsumers, light);
            } else {
                matrices.m_252781_(Axis.f_252403_.m_252977_(90.0f * (float)entity.getRotation()));
                this.renderPicture(matrices, vertexConsumers, picture, entity, light);
            }
        }
        matrices.m_85849_();
        super.m_7392_((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public void renderPicture(PoseStack matrices, MultiBufferSource vertexConsumers, RemotePicture picture, PictureFrameEntity entity, int light) {
        float scale = PictureFrameEntityRenderer.getPictureScale(picture, entity);
        float width = (float)picture.getWidth() * scale;
        float height = (float)picture.getHeight() * scale;
        float x1 = -width / 2.0f;
        float x2 = width / 2.0f;
        float y1 = -height / 2.0f;
        float y2 = height / 2.0f;
        RenderType renderLayer = entity.isPictureGlowing() ? RenderType.m_110497_((ResourceLocation)picture.getTextureIdentifier()) : RenderType.m_110452_((ResourceLocation)picture.getTextureIdentifier());
        VertexConsumer buffer = vertexConsumers.m_6299_(renderLayer);
        PoseStack.Pose matrix = matrices.m_85850_();
        Matrix4f matrix4f = matrix.m_252922_();
        Matrix3f matrix3f = matrix.m_252943_();
        int effectiveLight = entity.isPictureGlowing() ? 255 : light;
        buffer.m_252986_(matrix4f, x1, y1, 0.0f).m_193479_(-1).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(effectiveLight).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, x1, y2, 0.0f).m_193479_(-1).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(effectiveLight).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, x2, y2, 0.0f).m_193479_(-1).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(effectiveLight).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, x2, y1, 0.0f).m_193479_(-1).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(effectiveLight).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    private static float getPictureScale(RemotePicture picture, PictureFrameEntity entity) {
        float pictureWidth = picture.getWidth();
        float pictureHeight = picture.getHeight();
        if (entity.getRotation() % 2 == 1) {
            pictureWidth = picture.getHeight();
            pictureHeight = picture.getWidth();
        }
        float scaledWidth = (float)entity.getFrameWidth() / pictureWidth;
        float scaleHeight = (float)entity.getFrameHeight() / pictureHeight;
        return Math.min(scaledWidth, scaleHeight);
    }

    public void renderOutline(PoseStack matrices, MultiBufferSource vertexConsumers, float frameWidth, float frameHeight) {
        VoxelShape shape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)frameWidth, (double)frameHeight, (double)0.0625);
        LevelRenderer.m_285900_((PoseStack)matrices, (VertexConsumer)vertexConsumers.m_6299_(RenderType.m_110504_()), (VoxelShape)shape, (double)(-frameWidth / 2.0f), (double)(-frameHeight / 2.0f), (double)-0.03125, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (boolean)true);
    }

    public void renderFetching(PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.m_85841_(-0.015625f, -0.015625f, 0.015625f);
        String loading = LoadingDotsText.m_232744_((long)System.currentTimeMillis());
        MutableComponent fetching = Component.m_237115_((String)"text.camerapture.fetching_picture");
        Font font = this.m_114481_();
        Objects.requireNonNull(this.m_114481_());
        this.drawCenteredText(font, (Component)fetching, 0.0f, (float)(-9) - 0.5f, -1, matrices, vertexConsumers, light);
        this.drawCenteredText(this.m_114481_(), (Component)Component.m_237113_((String)loading), 0.0f, 0.5f, -8355712, matrices, vertexConsumers, light);
    }

    public void renderErrorText(PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.m_85841_(-0.015625f, -0.015625f, 0.015625f);
        MutableComponent text = Component.m_237115_((String)"text.camerapture.fetching_failed").m_130940_(ChatFormatting.RED);
        Font font = this.m_114481_();
        Objects.requireNonNull(this.m_114481_());
        this.drawCenteredText(font, (Component)text, 0.0f, (float)(-9) / 2.0f, -1, matrices, vertexConsumers, light);
    }

    private void drawCenteredText(Font textRenderer, Component text, float x, float y, int color, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        float width = textRenderer.m_92852_((FormattedText)text);
        textRenderer.m_272077_(text, x - width / 2.0f, y, color, false, matrices.m_85850_().m_252922_(), vertexConsumers, Font.DisplayMode.NORMAL, 0x7F000000, light);
    }

    public ResourceLocation getTexture(PictureFrameEntity entity) {
        return null;
    }

    public Vec3 getPositionOffset(PictureFrameEntity entity, float tickDelta) {
        Vector3d extra = entity.getFacing().m_253075_().transform(new Vector3d((double)(((float)entity.getFrameWidth() - 1.0f) / 2.0f), 0.0, (double)(-entity.getFrameHeight() + 2)));
        return new Vec3((double)((float)entity.getFacing().m_122429_() * 0.3f) + extra.x, -0.25 + extra.y, (double)((float)entity.getFacing().m_122431_() * 0.3f) + extra.z);
    }

    protected boolean hasLabel(PictureFrameEntity entity) {
        if (Minecraft.m_91404_() && entity.m_8077_()) {
            EntityHitResult hitResult;
            Minecraft client = Minecraft.m_91087_();
            HitResult hitResult2 = client.f_91077_;
            if (hitResult2 instanceof EntityHitResult && (hitResult = (EntityHitResult)hitResult2).m_82443_() == entity) {
                double d = this.f_114476_.m_114471_((Entity)entity);
                float f = entity.m_20163_() ? 32.0f : 64.0f;
                return d < (double)(f * f);
            }
        }
        return false;
    }
}

