/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.UUID;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class PictureItemRenderer {
    public static boolean canRender(ItemStack stack) {
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        if (pictureData == null) {
            return false;
        }
        RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(pictureData.id());
        return picture.getStatus() == RemotePicture.Status.SUCCESS;
    }

    public void render(@Nullable UUID data, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (data == null) {
            return;
        }
        RemotePicture picture = ClientPictureStore.getInstance().getServerPicture(data);
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.0f, 0.5f);
        matrices.m_252880_(0.0625f, 0.0625f, 0.0f);
        matrices.m_85841_(0.875f, 0.875f, 0.875f);
        if (picture.getWidth() > picture.getHeight()) {
            float height = (float)picture.getHeight() / (float)picture.getWidth();
            matrices.m_252880_(0.0f, (1.0f - height) / 2.0f, 0.0f);
            matrices.m_85841_(1.0f, height, 1.0f);
        } else {
            float width = (float)picture.getWidth() / (float)picture.getHeight();
            matrices.m_252880_((1.0f - width) / 2.0f, 0.0f, 0.0f);
            matrices.m_85841_(width, 1.0f, 1.0f);
        }
        RenderType renderLayer = RenderType.m_110458_((ResourceLocation)picture.getTextureIdentifier());
        VertexConsumer buffer = vertexConsumers.m_6299_(renderLayer);
        PoseStack.Pose matrix = matrices.m_85850_();
        Matrix4f matrix4f = matrix.m_252922_();
        Matrix3f matrix3f = matrix.m_252943_();
        buffer.m_252986_(matrix4f, 1.0f, 0.0f, 0.0f).m_193479_(-1).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, 1.0f, 1.0f, 0.0f).m_193479_(-1).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 1.0f, 0.0f).m_193479_(-1).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_193479_(-1).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        matrices.m_85849_();
    }

    @Nullable
    public UUID getData(ItemStack stack) {
        PictureItem.PictureData pictureData = PictureItem.getPictureData(stack);
        return pictureData != null ? pictureData.id() : null;
    }
}

