/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.util;

import com.luciad.imageio.webp.WebPWriteParam;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public final class ImageUtil
extends Enum<ImageUtil> {
    private static final /* synthetic */ ImageUtil[] $VALUES;

    public static ImageUtil[] values() {
        return (ImageUtil[])$VALUES.clone();
    }

    public static ImageUtil valueOf(String name) {
        return Enum.valueOf(ImageUtil.class, name);
    }

    public static NativeImage toNativeImage(BufferedImage image) {
        NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, image.getWidth(), image.getHeight(), false);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                nativeImage.m_84988_(x, y, ImageUtil.swapRedAndBlue(image.getRGB(x, y)));
            }
        }
        return nativeImage;
    }

    public static BufferedImage fromNativeImage(NativeImage image, boolean hasAlpha) {
        BufferedImage bufferedImage = new BufferedImage(image.m_84982_(), image.m_85084_(), hasAlpha ? 2 : 1);
        int[] pixels = image.m_266370_();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = ImageUtil.swapRedAndBlue(pixels[i]);
        }
        bufferedImage.setRGB(0, 0, image.m_84982_(), image.m_85084_(), pixels, 0, image.m_84982_());
        return bufferedImage;
    }

    private static int swapRedAndBlue(int pixel) {
        return pixel & 0xFF00FF00 | pixel << 16 & 0xFF0000 | pixel >> 16 & 0xFF;
    }

    public static BufferedImage clampSize(BufferedImage image, int maxDimension) {
        int height;
        int width;
        if (image.getWidth() <= maxDimension && image.getHeight() <= maxDimension) {
            return image;
        }
        if (image.getWidth() > image.getHeight()) {
            scale = (float)image.getWidth() / (float)maxDimension;
            width = maxDimension;
            height = (int)((float)image.getHeight() / scale);
        } else {
            scale = (float)image.getHeight() / (float)maxDimension;
            width = (int)((float)image.getWidth() / scale);
            height = maxDimension;
        }
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D g = scaledImage.createGraphics();
        g.drawImage(image.getScaledInstance(width, height, 4), 0, 0, width, height, null);
        g.dispose();
        return scaledImage;
    }

    public static byte[] compressIntoWebP(BufferedImage image, float quality) throws IOException {
        ImageWriter imageWriter = ImageIO.getImageWritersByMIMEType("image/webp").next();
        WebPWriteParam writeParam = new WebPWriteParam(imageWriter.getLocale());
        writeParam.setCompressionMode(2);
        writeParam.setCompressionType(writeParam.getCompressionTypes()[0]);
        writeParam.setAlphaCompression(1);
        writeParam.setCompressionQuality(quality);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream imageOutputStream = new MemoryCacheImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, new IIOImage(image, null, null), (ImageWriteParam)writeParam);
        imageWriter.dispose();
        imageOutputStream.flush();
        return outputStream.toByteArray();
    }

    private static /* synthetic */ ImageUtil[] $values() {
        return new ImageUtil[0];
    }

    static {
        $VALUES = ImageUtil.$values();
    }
}

