/*
 * Decompiled with CFR 0.152.
 */
package com.nonumberstudios.mob_randomizer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobRandomizerMod
implements ModInitializer {
    public static final String MODID = "mob_randomizer";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mob_randomizer");
    private static final class_1299<?>[] excluded = new class_1299[]{class_1299.field_6048, class_1299.field_6095, class_1299.field_6065, class_1299.field_6116, class_1299.field_6119, class_1299.field_6086};
    private static final class_1299<?>[] defaultBlazeMappings = new class_1299[]{class_1299.field_28315, class_1299.field_6108, class_1299.field_16281, class_1299.field_6132, class_1299.field_6070, class_1299.field_6085, class_1299.field_6067, class_1299.field_17943, class_1299.field_28402, class_1299.field_6139, class_1299.field_6143, class_1299.field_6057, class_1299.field_6081, class_1299.field_6104, class_1299.field_6093, class_1299.field_6062, class_1299.field_6140, class_1299.field_6073, class_1299.field_6115, class_1299.field_6114, class_1299.field_23214, class_1299.field_6111, class_1299.field_6113, class_1299.field_6077, class_1299.field_20346, class_1299.field_6084, class_1299.field_6087, class_1299.field_6091, class_1299.field_6074, class_1299.field_6146, class_1299.field_22281, class_1299.field_6042, class_1299.field_6079, class_1299.field_6055, class_1299.field_6050, class_1299.field_6099, class_1299.field_6046, class_1299.field_6123, class_1299.field_6107, class_1299.field_6118, class_1299.field_21973, class_1299.field_6071, class_1299.field_6102, class_1299.field_6078, class_1299.field_6105, class_1299.field_6134, class_1299.field_6137, class_1299.field_6069, class_1299.field_6098, class_1299.field_6145, class_1299.field_6076, class_1299.field_23696, class_1299.field_6051, class_1299.field_6054};
    private static final class_1299<?>[] defaultEndermanMappings = new class_1299[]{class_1299.field_28315, class_1299.field_6108, class_1299.field_16281, class_1299.field_6132, class_1299.field_6070, class_1299.field_6085, class_1299.field_6067, class_1299.field_17943, class_1299.field_28402, class_1299.field_6139, class_1299.field_6143, class_1299.field_6057, class_1299.field_6081, class_1299.field_6104, class_1299.field_6093, class_1299.field_6062, class_1299.field_6140, class_1299.field_6073, class_1299.field_6115, class_1299.field_6114, class_1299.field_23214, class_1299.field_6111, class_1299.field_6113, class_1299.field_6077, class_1299.field_20346, class_1299.field_6084, class_1299.field_6087, class_1299.field_6091, class_1299.field_6074, class_1299.field_6146, class_1299.field_22281, class_1299.field_6042, class_1299.field_6079, class_1299.field_6055, class_1299.field_6050, class_1299.field_6099, class_1299.field_6046, class_1299.field_6123, class_1299.field_6107, class_1299.field_6118, class_1299.field_21973, class_1299.field_6071, class_1299.field_6102, class_1299.field_6078, class_1299.field_6105, class_1299.field_6134, class_1299.field_6137, class_1299.field_6069, class_1299.field_6098, class_1299.field_6145, class_1299.field_6076, class_1299.field_23696, class_1299.field_6051, class_1299.field_6054};
    private static final Map<Integer, ArrayList<Integer>> allowedMappings = new HashMap<Integer, ArrayList<Integer>>();
    private static final Map<Integer, Integer> randomizer = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> compliment = new HashMap<Integer, Integer>();

    public static boolean canRandomize(class_1299<?> entity) {
        return entity.method_5891() != class_1311.field_17715 && Arrays.stream(excluded).noneMatch(e -> e == entity);
    }

    @NotNull
    public static class_1299<?> randomize(class_1299<?> entityIn) {
        if (!MobRandomizerMod.canRandomize(entityIn)) {
            return entityIn;
        }
        int id = class_2378.field_11145.method_10206(entityIn);
        return (class_1299)class_2378.field_11145.method_10200(randomizer.get(id).intValue());
    }

    @NotNull
    public static class_1299<?> compliment(class_1299<?> entityIn) {
        if (!MobRandomizerMod.canRandomize(entityIn)) {
            return entityIn;
        }
        int id = class_2378.field_11145.method_10206(entityIn);
        return (class_1299)class_2378.field_11145.method_10200(compliment.get(id).intValue());
    }

    private static void readConfig(Map<Integer, ArrayList<Integer>> map) {
        String configPath = FabricLoader.getInstance().getConfigDir() + File.separator + "mob_randomizer.json";
        File configFile = new File(configPath);
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                String content = Files.readString(Paths.get(configPath, new String[0]));
                JsonObject config = class_3518.method_15298((String)content, (boolean)true);
                JsonArray allowedMappings = config.getAsJsonArray("allowedMappings");
                allowedMappings.forEach(mapElement -> {
                    JsonObject entry = mapElement.getAsJsonObject();
                    class_2960 id = class_2960.method_12829((String)entry.getAsJsonPrimitive("mob-id").getAsString());
                    if (class_2378.field_11145.method_10250(id)) {
                        int rawId = class_2378.field_11145.method_10206((Object)((class_1299)class_2378.field_11145.method_10223(id)));
                        ArrayList list = new ArrayList();
                        JsonArray mappings = entry.getAsJsonArray("mappings");
                        mappings.forEach(idElement -> {
                            class_2960 mobid = class_2960.method_12829((String)idElement.getAsString());
                            list.add(class_2378.field_11145.method_10206((Object)((class_1299)class_2378.field_11145.method_10223(mobid))));
                        });
                        map.put(rawId, list);
                    } else {
                        LOGGER.error("Loaded invalid mob id: {}", (Object)id);
                    }
                });
                return;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to read config file with exception {}", (Object)exception.getMessage());
            }
        }
        LOGGER.info("Creating new config file...");
        try {
            JsonArray blazeMappings = new JsonArray();
            JsonArray endermanMappings = new JsonArray();
            for (class_1299<?> entity : defaultBlazeMappings) {
                blazeMappings.add(class_2378.field_11145.method_10221(entity).toString());
            }
            for (class_1299<?> entity : defaultEndermanMappings) {
                endermanMappings.add(class_2378.field_11145.method_10221(entity).toString());
            }
            JsonObject blazeEntry = new JsonObject();
            blazeEntry.addProperty("mob-id", class_2378.field_11145.method_10221((Object)class_1299.field_6099).toString());
            blazeEntry.add("mappings", (JsonElement)blazeMappings);
            JsonObject endermanEntry = new JsonObject();
            endermanEntry.addProperty("mob-id", class_2378.field_11145.method_10221((Object)class_1299.field_6091).toString());
            endermanEntry.add("mappings", (JsonElement)endermanMappings);
            JsonArray mappingsArray = new JsonArray();
            mappingsArray.add((JsonElement)blazeEntry);
            mappingsArray.add((JsonElement)endermanEntry);
            JsonObject config = new JsonObject();
            config.add("allowedMappings", (JsonElement)mappingsArray);
            Files.writeString(Paths.get(configPath, new String[0]), (CharSequence)config.toString(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to create config file with exception {}", (Object)exception.toString());
            LOGGER.error("Proceeding without config...");
        }
        LOGGER.info("Created new config successfully!");
    }

    public void onInitialize() {
        MobRandomizerMod.readConfig(allowedMappings);
        ArrayList ids = new ArrayList();
        ArrayList available = new ArrayList();
        class_2378.field_11145.forEach(entity -> {
            if (MobRandomizerMod.canRandomize(entity)) {
                int id = class_2378.field_11145.method_10206(entity);
                ids.add(id);
                available.add(id);
            }
        });
        Random random = new Random();
        for (int id : allowedMappings.keySet()) {
            if (!ids.contains(id)) continue;
            ArrayList mappings = new ArrayList(allowedMappings.get(id));
            mappings.retainAll(available);
            if (mappings.isEmpty()) {
                LOGGER.error("Entity {} does not have a valid mapping!", (Object)class_2378.field_11145.method_10221((Object)((class_1299)class_2378.field_11145.method_10200(id))));
                continue;
            }
            int mapTo = random.nextInt(mappings.size());
            randomizer.put((Integer)mappings.get(mapTo), id);
            compliment.put(id, (Integer)mappings.get(mapTo));
            LOGGER.info("Mapping {} -> {}", class_2378.field_11145.method_10200(((Integer)mappings.get(mapTo)).intValue()), class_2378.field_11145.method_10200(id));
            available.remove(mappings.get(mapTo));
            ids.remove((Object)id);
        }
        for (int id : ids) {
            if (available.isEmpty()) {
                LOGGER.error("Entity {} does not have a valid mapping!", (Object)class_2378.field_11145.method_10221((Object)((class_1299)class_2378.field_11145.method_10200(id))));
                break;
            }
            int mapTo = random.nextInt(available.size());
            randomizer.put((Integer)available.get(mapTo), id);
            compliment.put(id, (Integer)available.get(mapTo));
            LOGGER.info("Mapping {} -> {}", class_2378.field_11145.method_10200(((Integer)available.get(mapTo)).intValue()), class_2378.field_11145.method_10200(id));
            available.remove(mapTo);
        }
    }
}

