/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.container.menu;

import com.xiaoyue.celestial_artifacts.content.container.slot.PotionSlot;
import com.xiaoyue.celestial_artifacts.register.CAItems;
import com.xiaoyue.celestial_core.utils.ItemUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PotionsBagMenu
extends AbstractContainerMenu {
    public final ItemStack bag;
    public final Container bagInv;

    public static PotionsBagMenu fromNetwork(MenuType<?> type, int windowId, Inventory inv, FriendlyByteBuf buf) {
        return new PotionsBagMenu(type, windowId, inv, CAItems.POTIONS_BAG.asStack());
    }

    public PotionsBagMenu(MenuType<?> type, int id, Inventory inv, ItemStack bag) {
        super(type, id);
        this.bag = bag;
        this.bagInv = ItemUtils.getSimpleInv((ItemStack)bag, (int)54);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new PotionSlot(this.bagInv, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        this.addPlayerSlots((Container)inv, 85);
    }

    private void addPlayerSlots(Container playerInv, int yOffset) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot(playerInv, col + row * 9 + 9, 8 + col * 18, yOffset + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot(playerInv, col, 8 + col * 18, yOffset + 58));
        }
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            stack = slotItem.m_41777_();
            int size = this.bagInv.m_6643_();
            if (!slot.m_5857_(slotItem)) {
                return ItemStack.f_41583_;
            }
            if (index < size ? !this.m_38903_(slotItem, size, this.f_38839_.size(), true) : !this.m_38903_(slotItem, 0, size, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }

    public boolean m_6875_(Player player) {
        return ItemUtils.hasInHand((Player)player, (ItemStack)this.bag);
    }
}

