/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.back;

import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.AttrAdder;
import com.xiaoyue.celestial_artifacts.content.core.token.BaseTickingToken;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.content.core.token.TokenFacet;
import com.xiaoyue.celestial_artifacts.content.curios.curse.CatastropheScroll;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import dev.xkmc.l2library.capability.conditionals.NetworkSensitiveToken;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class TwistedScabbard
extends BaseTickingToken
implements NetworkSensitiveToken<TwistedScabbard>,
CAAttackToken {
    public static final TokenFacet<TwistedScabbard> TOKEN = new TokenFacet<TwistedScabbard>("twisted_scabbard", TwistedScabbard::new);
    @SerialClass.SerialField
    public int twisted_scabbard_add;
    @SerialClass.SerialField
    public int timer;

    private static int interval() {
        return (Integer)CAModConfig.COMMON.back.twistedScabbardInterval.get();
    }

    private static double atk() {
        return (Double)CAModConfig.COMMON.back.twistedScabbardAttack.get();
    }

    private static double endAtk() {
        return (Double)CAModConfig.COMMON.back.twistedScabbardAttackEnd.get();
    }

    @Override
    public void onPlayerKill(Player player, LivingDeathEvent event) {
        ++this.twisted_scabbard_add;
        this.timer = 0;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.sync(TOKEN.getKey(), this, sp);
        }
    }

    private AttrAdder attr(Player player) {
        return AttrAdder.of("twisted_scabbard", () -> Attributes.f_22281_, AttributeModifier.Operation.ADDITION, () -> this.getVal(player));
    }

    private double getVal(Player player) {
        double factor = TwistedScabbard.atk();
        if (CatastropheScroll.Curses.END.cursing(player)) {
            factor = TwistedScabbard.endAtk();
        }
        return 1.0 + (double)this.twisted_scabbard_add * factor;
    }

    @Override
    protected void removeImpl(Player player) {
        this.attr(player).removeImpl(player);
    }

    @Override
    protected void tickImpl(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        this.attr(player).tickImpl(player);
        ++this.timer;
        if (this.timer >= TwistedScabbard.interval() * 20) {
            this.timer = 0;
            if (this.twisted_scabbard_add > 0) {
                --this.twisted_scabbard_add;
                this.sync(TOKEN.getKey(), this, sp);
            }
        }
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Back.TWIST_0.get(new MutableComponent[0])));
        list.add((Component)TextFacet.wrap(CALang.Back.TWIST_1.get(TextFacet.num(TwistedScabbard.interval()))));
        list.add((Component)TextFacet.wrap(CALang.Back.TWIST_2.get(TextFacet.perc(TwistedScabbard.atk()))));
        list.add((Component)TextFacet.inner(CALang.Back.TWIST_3.get(CALang.Curse.END_TITLE.get(new MutableComponent[0]).m_130940_(ChatFormatting.RED), TextFacet.perc(TwistedScabbard.endAtk()))));
        list.add((Component)TextFacet.wrap(CALang.Back.TWIST_4.get(TextFacet.num(this.twisted_scabbard_add)).m_130940_(ChatFormatting.DARK_PURPLE)));
    }

    public void onSync(@Nullable TwistedScabbard old, Player player) {
    }
}

