/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.bracelet;

import com.xiaoyue.celestial_artifacts.content.core.modular.MultiLineText;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ScarletBracelet
implements MultiLineText,
CAAttackToken {
    private static double threshold() {
        return (Double)CAModConfig.COMMON.bracelet.scarletBraceletMaxCost.get();
    }

    private static double maxDamage() {
        return (Double)CAModConfig.COMMON.bracelet.scarletBraceletDamageLimit.get();
    }

    private static double damageBoost() {
        return (Double)CAModConfig.COMMON.bracelet.scarletBraceletDamageBonus.get();
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Bracelet.SCARLET_0.get(TextFacet.perc(ScarletBracelet.threshold()))));
        list.add((Component)TextFacet.wrap(CALang.Bracelet.SCARLET_1.get(TextFacet.percSmall(ScarletBracelet.damageBoost()), TextFacet.perc(ScarletBracelet.maxDamage()))));
    }

    @Override
    public void onPlayerHurtTarget(Player player, AttackCache cache) {
        float health = player.m_21233_() * (float)ScarletBracelet.threshold();
        if (player.m_21223_() > health) {
            float cost = player.m_21223_() - health;
            player.m_21153_(health);
            LivingEntity e = cache.getAttackTarget();
            float cap = (float)Math.min(ScarletBracelet.maxDamage(), (double)cost * ScarletBracelet.damageBoost());
            cache.addHurtModifier(DamageModifier.addExtra((float)(e.m_21233_() * cap)));
        }
    }
}

