/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.charm;

import com.xiaoyue.celestial_artifacts.content.core.effect.EffectFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TotemFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.BaseTickingToken;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.content.core.token.TokenFacet;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.curios.TotemHelper;
import dev.xkmc.l2library.capability.conditionals.NetworkSensitiveToken;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class CursedTotem
extends BaseTickingToken
implements NetworkSensitiveToken<CursedTotem>,
CAAttackToken,
TotemFacet {
    public static final TokenFacet<CursedTotem> TOKEN = new TokenFacet<CursedTotem>("cursed_totem", CursedTotem::new);
    @SerialClass.SerialField
    public int cursed_soul_totem;

    private static int maxLevel() {
        return (Integer)CAModConfig.COMMON.charm.cursedTotemMaxLevel.get();
    }

    private static int consume() {
        return (Integer)CAModConfig.COMMON.charm.cursedTotemConsumption.get();
    }

    private static int duration() {
        return (Integer)CAModConfig.COMMON.charm.cursedTotemEffectDuration.get();
    }

    private static int amplifier() {
        return (Integer)CAModConfig.COMMON.charm.cursedTotemEffectLevel.get();
    }

    public static MobEffectInstance eff() {
        return new MobEffectInstance(MobEffects.f_19615_, CursedTotem.duration() * 20, CursedTotem.amplifier());
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Charm.CURSED_TOTEM_1.get(EffectFacet.getDesc(CursedTotem.eff()))));
        list.add((Component)TextFacet.wrap(CALang.Charm.CURSED_TOTEM_2.get(TextFacet.num(CursedTotem.maxLevel()))));
        list.add((Component)TextFacet.wrap(CALang.Charm.CURSED_TOTEM_3.get(TextFacet.num(CursedTotem.consume()))));
        list.add((Component)TextFacet.wrap(CALang.Charm.CURSED_TOTEM_4.get(TextFacet.num(this.cursed_soul_totem)).m_130940_(ChatFormatting.DARK_PURPLE)));
    }

    @Override
    protected void removeImpl(Player player) {
    }

    @Override
    protected void tickImpl(Player player) {
    }

    @Override
    public void onPlayerDamagedFinal(Player player, AttackCache cache) {
        if (cache.getDamageDealt() < player.m_21223_() && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (this.cursed_soul_totem < CursedTotem.maxLevel()) {
                ++this.cursed_soul_totem;
                this.sync(TOKEN.getKey(), this, sp);
            }
        }
    }

    @Override
    public void trigger(Player self, ItemStack holded, TotemHelper.TotemSlot second, DamageSource source) {
        TotemFacet.super.trigger(self, holded, second, source);
        if (self instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)self;
            this.cursed_soul_totem -= CursedTotem.consume();
            this.sync(TOKEN.getKey(), this, sp);
        }
    }

    @Override
    public boolean allow(Player self, ItemStack stack, DamageSource source) {
        return this.cursed_soul_totem >= CursedTotem.consume() && TotemFacet.super.allow(self, stack, source);
    }

    public void onSync(@Nullable CursedTotem cursedTotem, Player player) {
    }
}

