/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.charm;

import com.xiaoyue.celestial_artifacts.content.core.effect.EffectFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.MultiLineText;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TotemFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_core.data.CCDamageTypes;
import com.xiaoyue.celestial_core.register.CCEffects;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.curios.TotemHelper;
import dev.xkmc.l2library.init.events.GeneralEventHandler;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SoulBox
implements MultiLineText,
CAAttackToken,
TotemFacet {
    private static int cooldown() {
        return (Integer)CAModConfig.COMMON.charm.soulBoxCooldown.get();
    }

    private static double damageFactor() {
        return (Double)CAModConfig.COMMON.charm.soulBoxReflect.get();
    }

    private static double effectChanceFactor() {
        return (Double)CAModConfig.COMMON.charm.soulBoxShatterChance.get();
    }

    private static int durHigh() {
        return (Integer)CAModConfig.COMMON.charm.soulBoxShatterHighDuration.get();
    }

    private static int ampHigh() {
        return (Integer)CAModConfig.COMMON.charm.soulBoxShatterHighLevel.get();
    }

    private static int durLow() {
        return (Integer)CAModConfig.COMMON.charm.soulBoxShatterLowDuration.get();
    }

    private static int ampLow() {
        return (Integer)CAModConfig.COMMON.charm.soulBoxShatterLowLevel.get();
    }

    private static MobEffectInstance effHigh() {
        return new MobEffectInstance((MobEffect)CCEffects.SOUL_SHATTER.get(), SoulBox.durHigh() * 20, SoulBox.ampHigh());
    }

    private static MobEffectInstance effLow() {
        return new MobEffectInstance((MobEffect)CCEffects.SOUL_SHATTER.get(), SoulBox.durLow() * 20, SoulBox.ampLow());
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Charm.SOUL_BOX_0.get(TextFacet.perc(SoulBox.effectChanceFactor()), EffectFacet.getDesc(SoulBox.effLow()))));
        list.add((Component)TextFacet.wrap(CALang.Charm.SOUL_BOX_1.get(TextFacet.num(SoulBox.cooldown()))));
        list.add((Component)TextFacet.inner(CALang.Charm.SOUL_BOX_2.get(EffectFacet.getDesc(SoulBox.effHigh()))));
        list.add((Component)TextFacet.inner(CALang.Charm.SOUL_BOX_3.get(TextFacet.perc(SoulBox.damageFactor()))));
    }

    @Override
    public void trigger(Player player, ItemStack stack, TotemHelper.TotemSlot slot, DamageSource source) {
        TotemFacet.super.trigger(player, stack, slot, source);
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.m_7292_(SoulBox.effHigh());
            GeneralEventHandler.schedule(() -> le.m_6469_(CCDamageTypes.abyss((LivingEntity)player), (float)((double)player.m_21233_() * SoulBox.damageFactor())));
        }
        player.m_36335_().m_41524_(stack.m_41720_(), SoulBox.cooldown() * 20);
    }

    @Override
    public void onPlayerDamaged(Player player, AttackCache cache) {
        if (cache.getAttacker() != null) {
            cache.getAttacker().m_7292_(SoulBox.effLow());
        }
    }
}

