/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.curios.charm;

import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.AttrAdder;
import com.xiaoyue.celestial_artifacts.content.core.token.BaseTickingToken;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.content.curios.curse.CatastropheScroll;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_core.utils.EntityUtils;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class WarDeadBadge
extends BaseTickingToken
implements CAAttackToken {
    @SerialClass.SerialField
    public float war_dead_badge_add;

    private static double damageFactor() {
        return (Double)CAModConfig.COMMON.charm.warDeadBadgeAtk.get();
    }

    private static double toughnessFactor() {
        return (Double)CAModConfig.COMMON.charm.warDeadBadgeArmor.get();
    }

    private static double speedFactor() {
        return (Double)CAModConfig.COMMON.charm.warDeadBadgeSpeed.get();
    }

    private static double getThreshold() {
        return (Double)CAModConfig.COMMON.charm.warDeadBadgeThreshold.get();
    }

    private static double healFactor() {
        return (Double)CAModConfig.COMMON.charm.warDeadBadgeHeal.get();
    }

    @Override
    public void addText(@Nullable Level level, List<Component> list) {
        list.add((Component)TextFacet.wrap(CALang.Charm.WAR_DEAD_BADGE_1.get(new MutableComponent[0])));
        list.add((Component)TextFacet.inner(this.atk().getText(WarDeadBadge.damageFactor())));
        list.add((Component)TextFacet.inner(this.tough().getText(WarDeadBadge.toughnessFactor())));
        list.add((Component)TextFacet.inner(this.speed().getText(WarDeadBadge.speedFactor())));
        list.add((Component)TextFacet.wrap(CALang.Charm.WAR_DEAD_BADGE_9.get(TextFacet.perc(WarDeadBadge.getThreshold()))));
        list.add((Component)TextFacet.inner(CALang.Charm.WAR_DEAD_BADGE_11.get(TextFacet.perc(WarDeadBadge.healFactor()))));
        list.add((Component)CALang.Modular.CURRENT_BONUS.get(new MutableComponent[0]).m_130940_(ChatFormatting.DARK_PURPLE));
        list.add((Component)TextFacet.wrap(this.atk().getTooltip()));
        list.add((Component)TextFacet.wrap(this.tough().getTooltip()));
        list.add((Component)TextFacet.wrap(this.speed().getTooltip()));
    }

    private AttrAdder atk() {
        return AttrAdder.of("war_dead_badge", () -> Attributes.f_22281_, AttributeModifier.Operation.MULTIPLY_BASE, (double)this.war_dead_badge_add * WarDeadBadge.damageFactor() * 100.0);
    }

    private AttrAdder tough() {
        return AttrAdder.of("war_dead_badge", () -> Attributes.f_22285_, AttributeModifier.Operation.MULTIPLY_BASE, (double)this.war_dead_badge_add * WarDeadBadge.toughnessFactor() * 100.0);
    }

    private AttrAdder speed() {
        return AttrAdder.of("war_dead_badge", () -> Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_BASE, (double)this.war_dead_badge_add * WarDeadBadge.speedFactor() * 100.0);
    }

    @Override
    protected void removeImpl(Player player) {
        this.atk().removeImpl(player);
        this.tough().removeImpl(player);
        this.speed().removeImpl(player);
    }

    @Override
    protected void tickImpl(Player player) {
        this.war_dead_badge_add = 1.0f - player.m_21223_() / player.m_21233_();
        this.atk().tickImpl(player);
        this.tough().tickImpl(player);
        this.speed().tickImpl(player);
    }

    @Override
    public void onPlayerHurtTarget(Player player, AttackCache cache) {
        if (CatastropheScroll.Curses.CHAOS.cursing(player) && (double)player.m_21223_() < (double)player.m_21233_() * WarDeadBadge.getThreshold()) {
            List entities = EntityUtils.getExceptForCentralEntity((LivingEntity)player, (float)8.0f, (float)2.0f);
            player.m_5634_((float)((double)(player.m_21233_() - player.m_21223_()) * WarDeadBadge.healFactor() * (double)entities.size()));
        }
    }
}

