/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.events;

import com.xiaoyue.celestial_artifacts.content.curios.charm.CursedTotem;
import com.xiaoyue.celestial_artifacts.content.curios.charm.GluttonyBadge;
import com.xiaoyue.celestial_artifacts.content.curios.charm.SacrificialObject;
import com.xiaoyue.celestial_artifacts.content.curios.curse.CatastropheScroll;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_artifacts.data.CATagGen;
import com.xiaoyue.celestial_artifacts.register.CAItems;
import com.xiaoyue.celestial_artifacts.utils.CurioUtils;
import com.xiaoyue.celestial_core.data.CCModConfig;
import com.xiaoyue.celestial_core.events.DamageItemEvent;
import com.xiaoyue.celestial_core.events.MenuSlotClickEvent;
import com.xiaoyue.celestial_core.register.CCItems;
import com.xiaoyue.celestial_core.utils.ItemUtils;
import dev.xkmc.l2library.base.effects.EffectBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.event.CurioEquipEvent;

@Mod.EventBusSubscriber(modid="celestial_artifacts", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CAMiscCuriosHandler {
    public static final String COPPER_REF = "CelestialCore_copperReinforce";
    public static final String AMETHYST_REF = "CelestialCore_amethystReinforce";

    @SubscribeEvent
    public static void anvilRecipe(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft().m_41777_();
        ItemStack right = event.getRight();
        if (!left.m_41763_()) {
            return;
        }
        if (right.m_150930_((Item)CAItems.COPPER_REINFORCE_PLATE.get())) {
            left.m_41784_().m_128379_(COPPER_REF, true);
            ItemUtils.defaultAnvilOutput((AnvilUpdateEvent)event, (ItemStack)left);
        }
        if (right.m_150930_((Item)CAItems.AMETHYST_REINFORCE_PLATE.get())) {
            left.m_41784_().m_128379_(AMETHYST_REF, true);
            ItemUtils.defaultAnvilOutput((AnvilUpdateEvent)event, (ItemStack)left);
        }
    }

    @SubscribeEvent
    public static void onItemDamage(DamageItemEvent event) {
        ItemStack stack = event.getStack();
        if (!stack.m_41782_()) {
            return;
        }
        if (stack.m_41783_().m_128471_(COPPER_REF)) {
            Double chance = (Double)CCModConfig.COMMON.copperReinforceChance.get();
            event.setAmount(ItemUtils.calculateRef((RandomSource)event.getRandom(), (int)event.getAmount(), (double)chance));
        }
        if (stack.m_41783_().m_128471_(AMETHYST_REF)) {
            event.setAmount(Math.min(event.getAmount(), 1));
        }
    }

    @SubscribeEvent
    public static void onMenuClick(MenuSlotClickEvent event) {
        if (event.getAction() != ClickAction.SECONDARY) {
            return;
        }
        ItemStack heldItem = event.getHeldItem();
        ItemStack slotItem = event.getSlotItem();
        if (slotItem.m_150930_((Item)CAItems.ENDER_JUMP_SCEPTER.get()) && heldItem.m_150930_(Items.f_42584_)) {
            heldItem.m_41774_(1);
            int charging = slotItem.m_41784_().m_128451_("CelestialCore_enderJumpScepter_charging");
            slotItem.m_41784_().m_128405_("CelestialCore_enderJumpScepter_charging", charging + 1);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41763_() && stack.m_41776_() >= CatastropheScroll.getOriginTrigger()) {
            CatastropheScroll.Curses.ORIGIN.trigger(player);
        }
        for (ItemStack e : player.m_6168_()) {
            if (!e.m_41793_()) continue;
            CatastropheScroll.Curses.CHAOS.trigger(player);
            break;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEnderManAnger(EnderManAngerEvent event) {
        ServerPlayer sp;
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).m_142582_((Entity)event.getEntity())) {
            CatastropheScroll.Curses.END.trigger((Player)sp);
        }
    }

    @SubscribeEvent
    public static void onEquipEtching(CurioEquipEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            if (event.getStack().m_204117_(CATagGen.ETCHINGS)) {
                CatastropheScroll.Curses.TRUTH.trigger((Player)sp);
            }
        }
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        Player player;
        AbstractArrow arrow;
        Entity entity;
        Projectile projectile = event.getProjectile();
        Entity entity2 = event.getEntity();
        if (projectile instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)projectile).m_19749_()) instanceof Player && CurioUtils.hasCurio(player = (Player)entity, (Item)CAItems.FLAME_ARROW_BAG.get())) {
            entity2.m_20254_(((Integer)CAModConfig.COMMON.back.flameArrowBagTime.get()).intValue());
        }
    }

    @SubscribeEvent
    public static void onAddedEffect(MobEffectEvent.Added event) {
        MobEffectInstance instance = event.getEffectInstance();
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (instance.m_19544_().m_19486_()) {
            CatastropheScroll.Curses.NIHILITY.trigger(player);
        }
        if (instance.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) {
            return;
        }
        if (!CatastropheScroll.Curses.NIHILITY.cursing(player)) {
            return;
        }
        double factor = CatastropheScroll.getNihilityCurse();
        new EffectBuilder(instance).setDuration((int)((double)instance.m_19557_() * (1.0 + factor)));
    }

    @SubscribeEvent
    public static void onFinishItemUse(LivingEntityUseItemEvent.Finish event) {
        Player player;
        ItemStack itemStack = event.getItem();
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && CurioUtils.hasCurio(player = (Player)entity, (Item)CAItems.GLUTTONY_BADGE.get()) && itemStack.m_41780_() == UseAnim.EAT) {
            player.m_7292_(GluttonyBadge.effAtk());
            player.m_7292_(GluttonyBadge.effReg());
        }
    }

    @SubscribeEvent
    public static void onStarItemUse(LivingEntityUseItemEvent.Tick event) {
        Player player;
        ItemStack itemStack = event.getItem();
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && CurioUtils.hasCurio(player = (Player)entity, (Item)CAItems.SPIRIT_BRACELET.get()) && CurioUtils.isRangeUseAnim(itemStack.m_41780_())) {
            event.setDuration(event.getDuration() - 1);
        }
    }

    @SubscribeEvent
    public static void onUseTotem(LivingUseTotemEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (entity instanceof Player && CurioUtils.hasCurio(player = (Player)entity, (Item)CAItems.CURSED_TOTEM.get()) && attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            livingEntity.m_7292_(CursedTotem.eff());
        }
    }

    @SubscribeEvent
    public static void onFishing(ItemFishedEvent event) {
        Player entity = event.getEntity();
        if (CurioUtils.hasCurio(entity, (Item)CAItems.TREASURE_HUNTER_NECKLACE.get())) {
            double chance = (Double)CAModConfig.COMMON.necklace.treasureHunterNecklaceChance.get();
            if (entity.m_217043_().m_188500_() <= chance && !entity.m_36335_().m_41519_((Item)CAItems.TREASURE_HUNTER_NECKLACE.get())) {
                Holder biome = entity.m_9236_().m_204166_(entity.m_20097_());
                int cooldown = (Integer)CAModConfig.COMMON.necklace.treasureHunterNecklaceCooldown.get();
                if (biome.m_203656_(BiomeTags.f_207610_)) {
                    entity.m_36356_(CCItems.JUNGLE_PYRAMID_LOOT_BOX.asStack());
                    entity.m_36335_().m_41524_((Item)CAItems.TREASURE_HUNTER_NECKLACE.get(), cooldown * 20);
                } else if (biome.m_203656_(BiomeTags.f_207614_)) {
                    entity.m_36356_(CCItems.DESERT_PYRAMID_LOOT_BOX.asStack());
                    entity.m_36335_().m_41524_((Item)CAItems.TREASURE_HUNTER_NECKLACE.get(), cooldown * 20);
                } else if (biome.m_203656_(BiomeTags.f_207615_)) {
                    entity.m_36356_(CCItems.IGLOO_LOOT_BOX.asStack());
                    entity.m_36335_().m_41524_((Item)CAItems.TREASURE_HUNTER_NECKLACE.get(), cooldown * 20);
                } else if (biome.m_203656_(BiomeTags.f_207595_)) {
                    entity.m_36356_(CCItems.MANSON_LOOT_BOX.asStack());
                    entity.m_36335_().m_41524_((Item)CAItems.TREASURE_HUNTER_NECKLACE.get(), cooldown * 20);
                } else if (biome.m_203656_(BiomeTags.f_207622_)) {
                    entity.m_36356_(CCItems.PILLAGER_OUTPOST_LOOT_BOX.asStack());
                    entity.m_36335_().m_41524_((Item)CAItems.TREASURE_HUNTER_NECKLACE.get(), cooldown * 20);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChangeLevel(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player entity = event.getEntity();
        if (CurioUtils.hasCurio(entity, (Item)CAItems.TRAVELER_SCROLL.get())) {
            entity.m_7292_(CAModConfig.COMMON.scroll.travelerScrollSpeedEffect());
            entity.m_7292_(CAModConfig.COMMON.scroll.travelerScrollRegenEffect());
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (CurioUtils.hasCurio(player, (Item)CAItems.SACRIFICIAL_OBJECT.get())) {
                SacrificialObject.onPlayerDeath(player);
            }
        }
    }

    public static void onEnchTable(@Nullable Slot slot, List<EnchantmentInstance> original) {
        Container container;
        if (slot != null && (container = slot.f_40218_) instanceof Inventory) {
            Inventory inv = (Inventory)container;
            Player player = inv.f_35978_;
            int lv = (Integer)CAModConfig.COMMON.pendant.chaoticPendantEnchantLevel.get();
            if (CurioUtils.hasCurio(player, (Item)CAItems.CHAOTIC_PENDANT.get())) {
                for (int i = 0; i < original.size(); ++i) {
                    EnchantmentInstance ins = original.get(i);
                    int ilv = Math.max(ins.f_44948_, Math.min(ins.f_44947_.m_6586_(), ins.f_44948_ + lv));
                    original.set(i, new EnchantmentInstance(ins.f_44947_, ilv));
                }
            }
        }
    }
}

