/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.generic;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;

public class CelestialEffect
extends MobEffect {
    public final boolean showIcon;

    public CelestialEffect(MobEffectCategory pCategory, int pColor, boolean showIcon) {
        super(pCategory, pColor);
        this.showIcon = showIcon;
    }

    public CelestialEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
        this.showIcon = true;
    }

    public boolean isFixed() {
        return true;
    }

    public List<ItemStack> getCurativeItems() {
        if (this.isFixed()) {
            return List.of();
        }
        return super.getCurativeItems();
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance instance) {
                return CelestialEffect.this.showIcon;
            }

            public boolean isVisibleInGui(MobEffectInstance instance) {
                return CelestialEffect.this.showIcon;
            }
        });
    }

    public boolean beRemove(MobEffectInstance instance, LivingEntity entity) {
        return true;
    }

    public static MobEffectCategory getCategory(int i) {
        return switch (i) {
            case 0 -> MobEffectCategory.BENEFICIAL;
            case 1 -> MobEffectCategory.NEUTRAL;
            case 2 -> MobEffectCategory.HARMFUL;
            default -> throw new IllegalStateException("unknown mobEffect category value: " + i);
        };
    }
}

