/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.generic;

import com.mojang.datafixers.util.Pair;
import com.xiaoyue.celestial_core.utils.ItemUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class DurableFoodItem
extends Item {
    public final ItemStack foodBase;

    public DurableFoodItem(Item.Properties pProperties) {
        super(pProperties);
        this.foodBase = this.m_7968_();
    }

    public DurableFoodItem(Item.Properties pProperties, Item foodBase) {
        super(pProperties);
        this.foodBase = foodBase.m_7968_();
    }

    public DurableFoodItem(Item.Properties pProperties, ItemStack foodBase) {
        super(pProperties);
        this.foodBase = foodBase;
    }

    public boolean isDrinkable() {
        return false;
    }

    public boolean isFast() {
        return false;
    }

    public boolean canShrink() {
        return false;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return this.isDrinkable() ? UseAnim.DRINK : UseAnim.EAT;
    }

    public int m_8105_(ItemStack pStack) {
        return this.isFast() ? 16 : 32;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (ItemUtils.getDurability(stack) > 1 && !this.canShrink()) {
            pPlayer.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (this.canShrink()) {
            pPlayer.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        this.eatFood(pLevel, pLivingEntity);
        ItemUtils.directDamage(pStack, 1);
        this.onConsume(pStack, pLivingEntity);
        return pStack;
    }

    public void eatFood(Level pLevel, LivingEntity pLivingEntity) {
        if (this.foodBase.m_41614_()) {
            FoodProperties prop = this.foodBase.getFoodProperties(pLivingEntity);
            if (pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                player.m_36324_().m_38707_(prop.m_38744_(), prop.m_38745_());
            }
            for (Pair ins : prop.m_38749_()) {
                if (pLevel.m_5776_() || ins.getFirst() == null || !(pLevel.f_46441_.m_188501_() < ((Float)ins.getSecond()).floatValue())) continue;
                pLivingEntity.m_7292_(new MobEffectInstance((MobEffectInstance)ins.getFirst()));
            }
        }
    }

    protected void onConsume(ItemStack stack, LivingEntity entity) {
    }
}

