/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.items;

import com.xiaoyue.celestial_core.data.CCLangData;
import com.xiaoyue.celestial_core.utils.ItemUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class LootTableBox
extends Item {
    public final ResourceLocation lootTable;
    public final boolean needFishing;

    public LootTableBox(Item.Properties pProperties, ResourceLocation lootTable) {
        super(pProperties);
        this.lootTable = lootTable;
        this.needFishing = true;
    }

    public LootTableBox(Item.Properties pProperties, ResourceLocation lootTable, boolean needFishing) {
        super(pProperties);
        this.lootTable = lootTable;
        this.needFishing = needFishing;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        String id = ItemUtils.getPathAfterSlash(this.lootTable.m_135815_());
        MutableComponent info = ItemUtils.getUSNameInfo(id).m_130940_(ChatFormatting.AQUA);
        list.add((Component)CCLangData.LOOT_BOX_INFO.get(info).m_130940_(ChatFormatting.GRAY));
        if (this.needFishing) {
            // empty if block
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack box = pPlayer.m_21120_(pUsedHand);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            List<ItemStack> stacks = ItemUtils.getDefaultLootStacks(this.lootTable, serverPlayer);
            for (ItemStack stack : stacks) {
                serverPlayer.m_36356_(stack);
            }
            ItemUtils.toShrink(box, (Player)serverPlayer);
            return InteractionResultHolder.m_19096_((Object)box);
        }
        return InteractionResultHolder.m_19100_((Object)box);
    }
}

