/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.content.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.xiaoyue.celestial_core.content.loot.DoubleConfigValue;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddItemModifier
extends LootModifier {
    public static final Codec<AddItemModifier> CODEC = RecordCodecBuilder.create(i -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)i).and(i.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)ForgeRegistries.ITEMS.getCodec().optionalFieldOf("fail").forGetter(m -> m.fail == Items.f_41852_ ? Optional.empty() : Optional.of(m.fail)), (App)Codec.STRING.optionalFieldOf("chance").forGetter(m -> Optional.ofNullable(m.chance).map(DoubleConfigValue::toData)))).apply((Applicative)i, AddItemModifier::new));
    public final Item item;
    public final Item fail;
    @Nullable
    public final DoubleConfigValue chance;

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item item, Optional<Item> fail, Optional<String> chance) {
        super(conditionsIn);
        this.item = item;
        this.fail = fail.orElse(Items.f_41852_);
        this.chance = chance.map(DoubleConfigValue::of).orElse(null);
    }

    public AddItemModifier(Item item, @Nullable DoubleConfigValue chance, LootItemCondition ... conditionsIn) {
        this(item, Items.f_41852_, chance, conditionsIn);
    }

    public AddItemModifier(Item item, Item fail, @Nullable DoubleConfigValue chance, LootItemCondition ... conditionsIn) {
        super(conditionsIn);
        this.item = item;
        this.fail = fail;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!context.m_78936_(LootContextParams.f_81457_)) {
            return generatedLoot;
        }
        if (this.chance == null || context.m_230907_().m_188500_() <= this.chance.get()) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item));
        } else {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.fail));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

