/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.data;

import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.xiaoyue.celestial_core.content.generic.PlayerFlagData;
import com.xiaoyue.celestial_core.register.CCEffects;
import com.xiaoyue.celestial_core.register.CelestialFlags;
import dev.xkmc.l2library.util.Proxy;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;

public enum CCLangData {
    BROKEN_TOTEM("%s chance to drop when triggering a totem", 1),
    BIOMES_FISHING("Can be fished from corresponding biomes if player has appropriate equipments", 0),
    LOOT_BOX_INFO("This box may contain items from %s", 1),
    ANVIL_FORGE_INFO("Forge with item on the anvil", 0),
    SIMPLE_DROP("%s chance to drop from %s", 2),
    AFTER_WITHER_DROP("After defeating %s, %s chance to drop from %s", 3),
    VOID_ESSENCE("Can be found in End City chests", 0),
    TREASURE_FRAGMENT("Can be found in Mineshaft chests", 0),
    DEATH_ESSENCE("%s chance to drop when mobs with at least %s health is killed by wither effect", 2),
    PURE_NETHER_STAR("Dropped from %s when killed by player with more than %s beneficial effects", 2),
    SHULKER_SCRAP("%s chance to drop when %s is killed by explosion", 2),
    SOARING_WINGS("Dropped when %s is killed above y=%s", 2),
    HEART_FRAGMENT("Dropped when %s is killed by charged Creeper", 1),
    SAKURA_FRAGMENT("%s chance to drop from breaking cherry blossom leaves", 1),
    VIRTUAL_GOLD_NUGGET("%s chance to drop from ignited mobs with enchanted gold armors", 1),
    OCEAN_TOOL("Cancel underwater dig speed penalty", 0),
    FULL_SET("Full set effect: %s", 1),
    SAKURA_SERIES("Restore 1 durability every %s seconds", 1),
    VIRTUAL_GOLD_TOOL("Increases attack damage and dig speed by %s for every enchantment it has", 1),
    VIRTUAL_GOLD_GENERAL("High enchantment affinity", 0);

    final String id = "celestial_core.tooltip." + this.name().toLowerCase(Locale.ROOT);
    final String def;
    final int count;

    private CCLangData(String def, int count) {
        this.def = def;
        this.count = count;
    }

    public MutableComponent get(Object ... objs) {
        if (objs.length != this.count) {
            throw new IllegalArgumentException("for " + this.name() + ": expect " + this.count + " parameters, got " + objs.length);
        }
        return Component.m_237110_((String)this.id, (Object[])objs);
    }

    public static MutableComponent chance(double v) {
        return Component.m_237113_((String)((int)Math.round(v * 100.0) + "%")).m_130940_(ChatFormatting.AQUA);
    }

    public static MutableComponent num(int v) {
        return Component.m_237113_((String)("" + v)).m_130940_(ChatFormatting.AQUA);
    }

    public static MutableComponent item(Item item) {
        return Component.m_237115_((String)item.m_5524_()).m_130940_(ChatFormatting.AQUA);
    }

    public static MutableComponent entity(EntityType<?> entity) {
        return entity.m_20676_().m_6881_().m_130940_(ChatFormatting.AQUA);
    }

    public static MutableComponent eff(MobEffect effect) {
        return effect.m_19482_().m_6881_().m_130940_(effect.m_19483_().m_19497_());
    }

    public static MutableComponent simpleDrop(EntityType<?> type, double v) {
        return SIMPLE_DROP.get(CCLangData.chance(v), type.m_20676_().m_6881_().m_130940_(ChatFormatting.AQUA));
    }

    public static MutableComponent witherDrop(EntityType<?> type, double v) {
        Player player = Proxy.getPlayer();
        boolean cleared = player != null && ((PlayerFlagData)PlayerFlagData.HOLDER.get(player)).hasFlag(CelestialFlags.NETHER_STAGE);
        return AFTER_WITHER_DROP.get(EntityType.f_20496_.m_20676_().m_6881_().m_130940_(cleared ? ChatFormatting.AQUA : ChatFormatting.RED), CCLangData.chance(v), type.m_20676_().m_6881_().m_130940_(ChatFormatting.AQUA));
    }

    public static MutableComponent deathEssence(double v, int i) {
        return DEATH_ESSENCE.get(CCLangData.chance(v), CCLangData.num(i));
    }

    public static void addLang(RegistrateLangProvider pvd) {
        for (CCLangData id : CCLangData.values()) {
            pvd.add(id.id, id.def);
        }
        List<Item> list = List.of(Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42738_);
        for (RegistryEntry<? extends Potion> ent : CCEffects.POTION_LIST) {
            for (Item item : list) {
                String pref = item.m_5524_();
                String[] prefs = pref.split("\\.");
                String str = ((Potion)ent.get()).m_43492_(item.m_5524_() + ".effect.");
                String[] ids = ((MobEffectInstance)((Potion)ent.get()).m_43488_().get(0)).m_19576_().split("\\.");
                String id = ids[ids.length - 1];
                String name = RegistrateLangProvider.toEnglishName((String)id);
                String pref_name = RegistrateLangProvider.toEnglishName((String)prefs[prefs.length - 1]);
                if (item == Items.f_42738_) {
                    pref_name = "Arrow";
                }
                pvd.add(str, pref_name + " of " + name);
            }
        }
    }
}

