/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.events;

import com.xiaoyue.celestial_core.content.generic.CelestialEffect;
import com.xiaoyue.celestial_core.content.generic.PlayerFlagData;
import com.xiaoyue.celestial_core.data.CCDamageTypes;
import com.xiaoyue.celestial_core.data.CCModConfig;
import com.xiaoyue.celestial_core.register.CCAttributes;
import com.xiaoyue.celestial_core.register.CCEffects;
import com.xiaoyue.celestial_core.register.CCItems;
import com.xiaoyue.celestial_core.register.CelestialFlags;
import com.xiaoyue.celestial_core.utils.EntityUtils;
import com.xiaoyue.celestial_core.utils.ScheduleUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="celestial_core", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CCGeneralEventHandler {
    @SubscribeEvent
    public static void onUseTotem(LivingUseTotemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_217043_().m_188500_() <= (Double)CCModConfig.COMMON.brokenTotemChance.get()) {
            player.m_36356_(CCItems.BROKEN_TOTEM.asStack());
        }
    }

    @SubscribeEvent
    public static void onEffectRemove(MobEffectEvent.Remove event) {
        CelestialEffect effect;
        MobEffectInstance instance = event.getEffectInstance();
        if (instance == null) {
            return;
        }
        MobEffect mobEffect = event.getEffect();
        if (mobEffect instanceof CelestialEffect && !(effect = (CelestialEffect)mobEffect).beRemove(instance, event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            ScheduleUtils.serverTick();
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (EntityUtils.onBlackFlame(entity)) {
            int time = EntityUtils.getBlackFlameTime(entity);
            EntityUtils.setBlackFlameTime(entity, time - 1);
            if (entity.f_19797_ % 10 == 0) {
                entity.m_6469_(CCDamageTypes.abyss(entity.m_9236_()), entity.m_21233_() * 0.01f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            double re = player.m_21133_((Attribute)CCAttributes.REPLY_POWER.get());
            event.setAmount((float)((double)event.getAmount() * re));
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof Player) {
            Player player = (Player)entity;
            double as = player.m_21133_((Attribute)CCAttributes.ARROW_SPEED.get());
            double ak = player.m_21133_((Attribute)CCAttributes.ARROW_KNOCK.get());
            if (!arrow.m_19880_().contains(CelestialFlags.ARROW_SPEED)) {
                arrow.m_20256_(arrow.m_20184_().m_82490_(as));
                arrow.m_20049_(CelestialFlags.ARROW_SPEED);
            }
            if (!arrow.m_19880_().contains(CelestialFlags.ARROW_KNOCK)) {
                arrow.m_36735_(arrow.m_150123_() + (int)ak);
                arrow.m_20049_(CelestialFlags.ARROW_KNOCK);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTeleport(EntityTeleportEvent event) {
        LivingEntity le;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity).m_21023_((MobEffect)CCEffects.ROTTEN_CURSE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (entity.m_21023_((MobEffect)CCEffects.UNYIELDING.get())) {
            event.setCanceled(true);
            entity.m_21153_(1.0f);
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            PlayerFlagData data = (PlayerFlagData)PlayerFlagData.HOLDER.get(player);
            if (entity instanceof WitherBoss && !data.hasFlag(CelestialFlags.NETHER_STAGE)) {
                data.addFlag(CelestialFlags.NETHER_STAGE);
            }
        }
    }
}

