/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.utils;

import com.xiaoyue.celestial_core.content.generic.EntityIntData;
import com.xiaoyue.celestial_core.register.CelestialFlags;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatVanillaType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    public static void spawnThunder(Level level, BlockPos pos, boolean onlyShow) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
        if (lightningBolt != null) {
            lightningBolt.m_20874_(onlyShow);
            lightningBolt.m_20219_(pos.m_252807_());
            level.m_7967_((Entity)lightningBolt);
        }
    }

    public static void spawnThunder(Level level, BlockPos pos) {
        EntityUtils.spawnThunder(level, pos, false);
    }

    public static void spawnThunder(Entity target) {
        EntityUtils.spawnThunder(target.m_9236_(), target.m_20097_());
    }

    public static AABB getAABB(LivingEntity center, float radius, float height) {
        return center.m_20191_().m_82377_((double)radius, (double)height, (double)radius);
    }

    public static List<LivingEntity> getExceptForCentralEntity(LivingEntity center, float radius, float height, Predicate<LivingEntity> predicate) {
        List entities = center.m_9236_().m_6443_(LivingEntity.class, EntityUtils.getAABB(center, radius, height), predicate);
        entities.remove(center);
        return entities;
    }

    public static List<LivingEntity> getExceptForCentralEntity(LivingEntity center, float radius, float height) {
        List entities = center.m_9236_().m_45976_(LivingEntity.class, EntityUtils.getAABB(center, radius, height));
        entities.remove(center);
        return entities;
    }

    public static List<LivingEntity> getDelimitedMonster(LivingEntity center, int range) {
        return center.m_9236_().m_6443_(LivingEntity.class, center.m_20191_().m_82400_((double)range), entities -> entities instanceof Enemy);
    }

    public static boolean isLookingBehindTarget(LivingEntity target, @Nullable Vec3 attackerLocation) {
        if (attackerLocation != null) {
            Vec3 lookingVector = target.m_20252_(1.0f);
            Vec3 attackAngleVector = attackerLocation.m_82546_(target.m_20182_()).m_82541_();
            attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
            return attackAngleVector.m_82526_(lookingVector) < -0.5;
        }
        return false;
    }

    public static boolean onBlackFlame(LivingEntity entity) {
        return EntityIntData.getData(entity, CelestialFlags.BLACK_FLAME) > 0;
    }

    public static int getBlackFlameTime(LivingEntity entity) {
        return EntityIntData.getData(entity, CelestialFlags.BLACK_FLAME);
    }

    public static void setBlackFlameTime(LivingEntity entity, int time) {
        EntityIntData.addData(entity, CelestialFlags.BLACK_FLAME, time);
    }

    public static void clearBlackFlame(LivingEntity entity) {
        EntityIntData.removeData(entity, CelestialFlags.BLACK_FLAME);
    }

    public static <I extends Item> int getSeriesArmorAmount(LivingEntity entity, I item) {
        int amount = 0;
        for (ItemStack armor : entity.m_6168_()) {
            if (!armor.m_150930_(item)) continue;
            ++amount;
        }
        return amount;
    }

    public static int getSeriesArmorAmount(LivingEntity entity, Item ... items) {
        int amount = 0;
        for (ItemStack armor : entity.m_6168_()) {
            amount += (int)Arrays.stream(items).filter(arg_0 -> ((ItemStack)armor).m_150930_(arg_0)).count();
        }
        return amount;
    }

    public static int getSeriesArmorAmount(LivingEntity entity, IMatVanillaType type) {
        return EntityUtils.getSeriesArmorAmount(entity, type.getArmor(EquipmentSlot.HEAD), type.getArmor(EquipmentSlot.CHEST), type.getArmor(EquipmentSlot.LEGS), type.getArmor(EquipmentSlot.FEET));
    }

    public static int getEquipArmorAmount(LivingEntity entity) {
        int amount = 0;
        for (ItemStack stack : entity.m_6168_()) {
            if (stack.m_41619_()) continue;
            ++amount;
        }
        return amount;
    }

    public static void hurtByPlayerOrMob(LivingEntity target, @Nullable LivingEntity attacker, float damage) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            target.m_6469_(player.m_269291_().m_269075_(player), damage);
        } else if (attacker != null) {
            target.m_6469_(attacker.m_269291_().m_269333_(attacker), damage);
        } else {
            target.m_6469_(target.m_269291_().m_269264_(), damage);
        }
    }

    public static boolean isFullCharged(Player player) {
        return player.m_36403_(0.5f) > 0.9f;
    }

    public static float getPerMissHp(LivingEntity entity) {
        return 1.0f - entity.m_21223_() / entity.m_21233_();
    }

    public static void setPlayerXpLevel(Player player, int level) {
        player.f_36078_ = level;
    }

    public static boolean isEndEntity(LivingEntity entity) {
        return entity instanceof EnderMan || entity instanceof EnderDragon || entity instanceof Shulker || entity instanceof Endermite;
    }

    public static boolean nullArmor(LivingEntity entity) {
        return EntityUtils.getEquipArmorAmount(entity) == 0;
    }

    public static boolean hasArmor(LivingEntity entity) {
        return EntityUtils.getEquipArmorAmount(entity) > 0;
    }

    public static boolean isEmptyInHand(LivingEntity entity) {
        return entity.m_21205_().m_41619_() && entity.m_21206_().m_41619_();
    }

    public static int getEffectLevel(LivingEntity entity, MobEffect effect) {
        MobEffectInstance instance = entity.m_21124_(effect);
        return instance == null ? -1 : instance.m_19564_();
    }

    public static int getEffectCount(LivingEntity entity, MobEffectCategory category) {
        return (int)entity.m_21220_().stream().filter(e -> e.m_19544_().m_19483_().equals((Object)category)).count();
    }

    public static int getHarmfulEffect(LivingEntity entity) {
        return EntityUtils.getEffectCount(entity, MobEffectCategory.HARMFUL);
    }

    public static int getBeneficialEffect(LivingEntity entity) {
        return EntityUtils.getEffectCount(entity, MobEffectCategory.BENEFICIAL);
    }

    public static void addEct(LivingEntity entity, MobEffect effect, int time, int level) {
        entity.m_147207_(new MobEffectInstance(effect, time, level, false, false, true), (Entity)entity);
    }

    public static void addEct(LivingEntity entity, MobEffect effect, int time) {
        entity.m_147207_(new MobEffectInstance(effect, time, 0, false, false, true), (Entity)entity);
    }
}

