/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_core.utils;

import com.xiaoyue.celestial_core.CelestialCore;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ScheduleUtils {
    private static final Map<ResourceLocation, ScheduleUtils> MAP = new HashMap<ResourceLocation, ScheduleUtils>();
    public int runTick = 0;
    public int runCount = 0;
    public int needRunTick;
    public int needRunCount;
    public final Runnable action;
    public boolean isEnd;

    public ScheduleUtils(int singleRunTick, Runnable action) {
        this.needRunTick = singleRunTick;
        this.needRunCount = 1;
        this.action = action;
    }

    public ScheduleUtils(int needRunTick, int needRunCount, Runnable action) {
        this.needRunTick = needRunTick;
        this.needRunCount = needRunCount;
        this.action = action;
    }

    @Nullable
    public static ScheduleUtils getUtils(ResourceLocation id) {
        if (!MAP.isEmpty()) {
            return MAP.get(id);
        }
        return null;
    }

    public static void serverTick() {
        if (MAP.isEmpty()) {
            return;
        }
        MAP.forEach((key, utils) -> {
            if (utils.runTick >= utils.needRunTick) {
                utils.action.run();
                ++utils.runCount;
                if (utils.runCount >= utils.needRunCount) {
                    utils.isEnd = true;
                    CelestialCore.LOGGER.info("{}: schedule end", (Object)key.toString());
                } else {
                    utils.runTick = 0;
                    utils.isEnd = false;
                    CelestialCore.LOGGER.info("{}: {} time schedule completion", (Object)key.toString(), (Object)utils.runCount);
                }
            } else {
                ++utils.runTick;
                utils.isEnd = false;
            }
        });
        MAP.entrySet().removeIf(entry -> ((ScheduleUtils)entry.getValue()).isEnd);
    }

    public static void schedule(ResourceLocation id, int needRunTick, Runnable action) {
        ScheduleUtils utils = new ScheduleUtils(needRunTick, action);
        MAP.put(id, utils);
    }

    public static void schedule(ResourceLocation id, int needRunTick, int needRunCount, Runnable action) {
        ScheduleUtils utils = new ScheduleUtils(needRunTick, needRunCount, action);
        MAP.put(id, utils);
    }
}

