/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts;

import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.xiaoyue.celestial_artifacts.content.core.modular.CurioCacheCap;
import com.xiaoyue.celestial_artifacts.data.CAGLMProvider;
import com.xiaoyue.celestial_artifacts.data.CALang;
import com.xiaoyue.celestial_artifacts.data.CALootTableGen;
import com.xiaoyue.celestial_artifacts.data.CAModConfig;
import com.xiaoyue.celestial_artifacts.data.CARecipeGen;
import com.xiaoyue.celestial_artifacts.data.CASlotGen;
import com.xiaoyue.celestial_artifacts.data.CATagGen;
import com.xiaoyue.celestial_artifacts.events.CAAttackListener;
import com.xiaoyue.celestial_artifacts.register.CAItems;
import com.xiaoyue.celestial_artifacts.register.CALootModifier;
import com.xiaoyue.celestial_artifacts.register.CAMenus;
import com.xiaoyue.celestial_artifacts.register.CAbilityPacket;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.serial.config.PacketHandler;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="celestial_artifacts")
@Mod.EventBusSubscriber(modid="celestial_artifacts", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CelestialArtifacts {
    public static final String MODID = "celestial_artifacts";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final L2Registrate REGISTRATE = new L2Registrate("celestial_artifacts");
    public static final RegistryEntry<CreativeModeTab> TAB = REGISTRATE.buildModCreativeTab("curios", "Celestial Artifacts", e -> e.m_257737_(() -> CAItems.AMETHYST_RING.asStack()));
    public static final PacketHandler HANDLER = new PacketHandler(CelestialArtifacts.loc("main"), 1, new Function[]{e -> e.create(CAbilityPacket.class, NetworkDirection.PLAY_TO_SERVER)});

    public CelestialArtifacts() {
        CAItems.register();
        CALootModifier.register();
        CurioCacheCap.register();
        CAMenus.register();
        CAModConfig.init();
        AttackEventHandler.register((int)3460, (AttackListener)new CAAttackListener());
        REGISTRATE.addDataGenerator(ProviderType.LANG, CALang::addLang);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, CARecipeGen::onRecipeGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, CATagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, CATagGen::onEntityTagGen);
        REGISTRATE.addDataGenerator(ProviderType.LOOT, CALootTableGen::onLootGen);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        boolean included = event.includeServer();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        gen.addProvider(included, (DataProvider)new CAGLMProvider(output));
        gen.addProvider(included, (DataProvider)new CASlotGen(gen));
    }

    public static ResourceLocation loc(String id) {
        return new ResourceLocation(MODID, id);
    }
}

