/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.celestial_artifacts.content.core.attack;

import com.xiaoyue.celestial_artifacts.content.core.modular.IFacet;
import com.xiaoyue.celestial_artifacts.content.core.modular.TextFacet;
import com.xiaoyue.celestial_artifacts.content.core.token.CAAttackToken;
import com.xiaoyue.celestial_artifacts.data.CALang;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SimpleListener {
    public static IFacet hurtBonus(Supplier<MutableComponent> text, HurtBonusPredicate condition, DoubleSupplier bonus) {
        return new HurtBonus(text, condition, bonus);
    }

    public static IFacet protect(Supplier<MutableComponent> text, ProtectPredicate condition, DoubleSupplier bonus) {
        return new Protection(text, condition, bonus);
    }

    public static IFacet protectType(CALang.DamageTypes text, DoubleSupplier bonus) {
        return new ProtectionType(() -> text.get(new MutableComponent[0]), text::pred, bonus);
    }

    public static IFacet avoidType(CALang.DamageTypes text, DoubleSupplier chance) {
        return new AvoidType(() -> text.get(new MutableComponent[0]), text::pred, chance);
    }

    public static IFacet negateType(CALang.DamageTypes text) {
        return new AvoidType(() -> text.get(new MutableComponent[0]), text::pred, null);
    }

    record HurtBonus(Supplier<MutableComponent> text, HurtBonusPredicate condition, DoubleSupplier bonus) implements TextFacet,
    CAAttackToken
    {
        @Override
        public void addText(@Nullable Level level, List<Component> list) {
            list.add((Component)TextFacet.wrap(this.text.get()));
            list.add((Component)TextFacet.inner(CALang.Modular.HURT_BONUS.get(TextFacet.perc(this.bonus.getAsDouble())).m_130940_(ChatFormatting.GRAY)));
        }

        @Override
        public void onPlayerHurtTarget(Player player, AttackCache cache) {
            if (this.condition.test(player, cache.getAttackTarget(), cache)) {
                cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + this.bonus.getAsDouble()))));
            }
        }
    }

    public static interface HurtBonusPredicate {
        public boolean test(Player var1, LivingEntity var2, AttackCache var3);
    }

    record Protection(Supplier<MutableComponent> text, ProtectPredicate condition, DoubleSupplier bonus) implements TextFacet,
    CAAttackToken
    {
        @Override
        public void addText(@Nullable Level level, List<Component> list) {
            list.add((Component)TextFacet.wrap(this.text.get()));
            list.add((Component)TextFacet.inner(CALang.Modular.PROTECT.get(TextFacet.perc(this.bonus.getAsDouble())).m_130940_(ChatFormatting.GRAY)));
        }

        @Override
        public void onPlayerDamaged(Player player, AttackCache cache) {
            if (this.condition.test(player, cache.getAttackTarget(), cache)) {
                cache.addDealtModifier(DamageModifier.multTotal((float)((float)(1.0 - this.bonus.getAsDouble()))));
            }
        }
    }

    public static interface ProtectPredicate {
        public boolean test(Player var1, LivingEntity var2, AttackCache var3);
    }

    record ProtectionType(Supplier<MutableComponent> text, Predicate<DamageSource> condition, DoubleSupplier bonus) implements TextFacet,
    CAAttackToken
    {
        @Override
        public void addText(@Nullable Level level, List<Component> list) {
            list.add((Component)TextFacet.wrap(CALang.Modular.PROTECT_TYPE.get(this.text.get(), TextFacet.perc(this.bonus.getAsDouble())).m_130940_(ChatFormatting.GRAY)));
        }

        @Override
        public void onPlayerDamaged(Player player, AttackCache cache) {
            if (this.condition.test(CAAttackToken.getSource(cache))) {
                cache.addDealtModifier(DamageModifier.multTotal((float)((float)(1.0 - this.bonus.getAsDouble()))));
            }
        }
    }

    record AvoidType(Supplier<MutableComponent> text, Predicate<DamageSource> condition, @Nullable DoubleSupplier chance) implements TextFacet,
    CAAttackToken
    {
        @Override
        public void addText(@Nullable Level level, List<Component> list) {
            if (this.chance == null) {
                list.add((Component)TextFacet.wrap(CALang.Modular.NEGATE_TYPE.get(this.text.get()).m_130940_(ChatFormatting.GRAY)));
            } else {
                list.add((Component)TextFacet.wrap(CALang.Modular.DODGE_TYPE.get(TextFacet.perc(this.chance.getAsDouble()), this.text.get()).m_130940_(ChatFormatting.GRAY)));
            }
        }

        @Override
        public boolean onPlayerAttacked(Player player, AttackCache cache) {
            return this.condition.test(CAAttackToken.getSource(cache)) && (this.chance == null || CAAttackToken.chance((LivingEntity)player, this.chance.getAsDouble()));
        }
    }
}

